/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.RadiusUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;

public class RadiusAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private List<RadiusServer> servers;
    private boolean failoverOnException;
    private boolean failoverOnAuthenticationFailure;

    public RadiusAuthenticationHandler() {
        this.logger.debug("Using {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        try {
            String username = credential.getUsername();
            Pair result = RadiusUtils.authenticate((String)username, (String)credential.getPassword(), this.servers, (boolean)this.failoverOnAuthenticationFailure, (boolean)this.failoverOnException);
            if (((Boolean)result.getKey()).booleanValue()) {
                return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username, (Map)((Optional)result.getValue()).get()), new ArrayList());
            }
            throw new FailedLoginException("Radius authentication failed for user " + username);
        }
        catch (Exception e) {
            throw new FailedLoginException("Radius authentication failed " + e.getMessage());
        }
    }

    public void setFailoverOnAuthenticationFailure(boolean failoverOnAuthenticationFailure) {
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }

    public void setFailoverOnException(boolean failoverOnException) {
        this.failoverOnException = failoverOnException;
    }

    public void setServers(List<RadiusServer> servers) {
        this.servers = servers;
    }
}

