/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DistributedJEESessionStore
implements SessionStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedJEESessionStore.class);
    private static final String SESSION_ID_IN_REQUEST_ATTRIBUTE = "sessionIdInRequestAttribute";
    private final CentralAuthenticationService centralAuthenticationService;
    private final TicketFactory ticketFactory;
    private final CasCookieBuilder cookieGenerator;

    public Optional<String> getSessionId(WebContext webContext, boolean create) {
        String sessionId = this.fetchSessionIdFromContext(webContext);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = UUID.randomUUID().toString();
            LOGGER.trace("Generated session id: [{}]", (Object)sessionId);
            JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
            this.cookieGenerator.addCookie(context.getNativeRequest(), context.getNativeResponse(), sessionId);
            context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, (Object)sessionId);
        }
        return Optional.of(sessionId);
    }

    public Optional get(WebContext context, String key) {
        LOGGER.trace("Getting key: [{}]", (Object)key);
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (ticket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ticket.getProperties().get(key));
    }

    public void set(WebContext context, String key, Object value) {
        LOGGER.trace("Setting key: [{}]", (Object)key);
        String sessionId = this.fetchSessionIdFromContext(context);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (value instanceof Serializable) {
            properties.put(key, (Serializable)value);
        } else if (value != null) {
            LOGGER.trace("Object value [{}] assigned to [{}] is not serializable and may not be part of the ticket [{}]", new Object[]{value, key, sessionId});
        }
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (value == null && ticket != null) {
            ticket.getProperties().remove(key);
            this.centralAuthenticationService.updateTicket((Ticket)ticket);
        } else if (ticket == null) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            ticket = transientFactory.create(sessionId, properties);
            this.centralAuthenticationService.addTicket((Ticket)ticket);
        } else {
            ticket.getProperties().putAll(properties);
            this.centralAuthenticationService.updateTicket((Ticket)ticket);
        }
    }

    public boolean destroySession(WebContext webContext) {
        String sessionId = this.fetchSessionIdFromContext(webContext);
        String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
        this.centralAuthenticationService.deleteTicket(ticketId);
        JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
        this.cookieGenerator.removeCookie(context.getNativeResponse());
        LOGGER.trace("Removes session cookie and ticket: [{}]", (Object)ticketId);
        return true;
    }

    public Optional getTrackableSession(WebContext context) {
        String sessionId = this.fetchSessionIdFromContext(context);
        LOGGER.trace("Track sessionId: [{}]", (Object)sessionId);
        return Optional.of(sessionId);
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, trackableSession);
        LOGGER.trace("Force sessionId: [{}]", trackableSession);
        return Optional.of(this);
    }

    public boolean renewSession(WebContext context) {
        return false;
    }

    protected String fetchSessionIdFromContext(WebContext webContext) {
        String sessionId = webContext.getRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE).orElse(null);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            JEEContext context = (JEEContext)JEEContext.class.cast(webContext);
            sessionId = this.cookieGenerator.retrieveCookieValue(context.getNativeRequest());
        }
        LOGGER.trace("Generated session id: [{}]", (Object)sessionId);
        return sessionId;
    }

    private TransientSessionTicket getTransientSessionTicketForSession(WebContext context) {
        try {
            String sessionId = this.fetchSessionIdFromContext(context);
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
            LOGGER.trace("fetching ticket: [{}]", (Object)ticketId);
            return (TransientSessionTicket)this.centralAuthenticationService.getTicket(ticketId, TransientSessionTicket.class);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Generated
    public DistributedJEESessionStore(CentralAuthenticationService centralAuthenticationService, TicketFactory ticketFactory, CasCookieBuilder cookieGenerator) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketFactory = ticketFactory;
        this.cookieGenerator = cookieGenerator;
    }
}

