/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pac4j.serialization.NimbusOAuthJacksonModule;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="Simple")
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ExtendWith(value={CasTestExtension.class})
class NimbusOAuthJacksonModuleTests {
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    NimbusOAuthJacksonModuleTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        AbstractJacksonBackedStringSerializer serializer = new AbstractJacksonBackedStringSerializer(this.applicationContext){
            private static final long serialVersionUID = 1083978605633757365L;

            public Class getTypeToSerialize() {
                return Object.class;
            }
        };
        ObjectMapper mapper = serializer.getObjectMapper();
        Assertions.assertTrue((boolean)mapper.getRegisteredModuleIds().contains(NimbusOAuthJacksonModule.class.getName()));
        NimbusOAuthJacksonModuleTests.runTest(serializer, CodeVerifier.class, new CodeVerifier(RandomUtils.randomAlphabetic((int)43)));
        NimbusOAuthJacksonModuleTests.runTest(serializer, BearerAccessToken.class, new BearerAccessToken("access-token-value"));
        NimbusOAuthJacksonModuleTests.runTest(serializer, RefreshToken.class, new RefreshToken("access-token-value"));
        NimbusOAuthJacksonModuleTests.runTest(serializer, AccessTokenType.class, AccessTokenType.BEARER);
        NimbusOAuthJacksonModuleTests.runTest(serializer, Scope.class, new Scope(new String[]{"profile"}));
    }

    private static void runTest(AbstractJacksonBackedStringSerializer serializer, Class clazz, Object object) throws Exception {
        ObjectMapper mapper = serializer.getObjectMapper();
        String content = mapper.writeValueAsString(object);
        Assertions.assertNotNull((Object)mapper.readValue(content, clazz));
    }
}

