/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.integration.pac4j.BaseSessionStoreTests;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BrowserStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={BaseSessionStoreTests.SharedTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Web")
@ExtendWith(value={CasTestExtension.class})
class BrowserWebStorageSessionStoreTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).minimal(false).build().toObjectMapper();
    @Autowired
    @Qualifier(value="webflowCipherExecutor")
    private CipherExecutor webflowCipherExecutor;

    BrowserWebStorageSessionStoreTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        BrowserWebStorageSessionStore store = new BrowserWebStorageSessionStore(this.webflowCipherExecutor, "ContextKey");
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        store.set((WebContext)ctx, "key1", (Object)"value1");
        store.set((WebContext)ctx, "key2", List.of("HelloWorld"));
        store.set((WebContext)ctx, "key3", (Object)1234567);
        store.set((WebContext)ctx, "dummy", (Object)new Dummy());
        Optional session = store.getTrackableSession((WebContext)ctx);
        Assertions.assertTrue((boolean)session.isPresent());
        store.renewSession((WebContext)ctx);
        BrowserStorage storage = (BrowserStorage)session.get();
        store.buildFromTrackableSession((WebContext)ctx, (Object)MAPPER.writeValueAsString(Map.of(storage.getContext(), storage.getPayload())));
        Assertions.assertTrue((boolean)store.get((WebContext)ctx, "key1").isPresent());
        Assertions.assertTrue((boolean)store.get((WebContext)ctx, "key2").isPresent());
        Assertions.assertTrue((boolean)store.get((WebContext)ctx, "key3").isPresent());
        Assertions.assertTrue((boolean)store.get((WebContext)ctx, "dummy").isPresent());
    }

    private static final class Dummy
    implements Serializable {
        private static final long serialVersionUID = 7015295901443767970L;

        private Dummy() {
        }
    }
}

