/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import org.apereo.cas.pac4j.serialization.NimbusOAuthJacksonModule;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Simple")
class NimbusOAuthJacksonModuleTests {
    private static final AbstractJacksonBackedStringSerializer SERIALIZER = new AbstractJacksonBackedStringSerializer(){
        private static final long serialVersionUID = 1083978605633757365L;

        public Class getTypeToSerialize() {
            return Object.class;
        }
    };

    NimbusOAuthJacksonModuleTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        ObjectMapper mapper = SERIALIZER.getObjectMapper();
        Assertions.assertTrue((boolean)mapper.getRegisteredModuleIds().contains(NimbusOAuthJacksonModule.class.getName()));
        NimbusOAuthJacksonModuleTests.runTest(CodeVerifier.class, new CodeVerifier(RandomUtils.randomAlphabetic((int)43)));
        NimbusOAuthJacksonModuleTests.runTest(BearerAccessToken.class, new BearerAccessToken("access-token-value"));
        NimbusOAuthJacksonModuleTests.runTest(RefreshToken.class, new RefreshToken("access-token-value"));
        NimbusOAuthJacksonModuleTests.runTest(AccessTokenType.class, AccessTokenType.BEARER);
        NimbusOAuthJacksonModuleTests.runTest(Scope.class, new Scope(new String[]{"profile"}));
    }

    private static void runTest(Class clazz, Object object) throws Exception {
        ObjectMapper mapper = SERIALIZER.getObjectMapper();
        String content = mapper.writeValueAsString(object);
        Assertions.assertNotNull((Object)mapper.readValue(content, clazz));
    }
}

