/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.integration.pac4j.BaseSessionStoreTests;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.InvalidCookieException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={BaseSessionStoreTests.SharedTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Web")
public class DistributedJEESessionStoreTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private TicketFactory ticketFactory;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    private HttpServletRequest request;
    private MockHttpServletResponse response;
    private SessionStore sessionStore;
    private WebContext webContext;
    private CasCookieBuilder cookieGenerator;

    @BeforeEach
    public void setup() {
        this.ticketRegistry.deleteAll();
        CookieSessionReplicationProperties cookie = this.casProperties.getAuthn().getPac4j().getCore().getSessionReplication().getCookie();
        this.cookieGenerator = CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.sessionStore = new DistributedJEESessionStore(this.ticketRegistry, this.ticketFactory, this.cookieGenerator);
        this.webContext = new JEEContext(this.request, (HttpServletResponse)this.response);
    }

    @Test
    public void verifyTracking() {
        Assertions.assertNotNull((Object)this.request.getSession());
        Assertions.assertFalse((boolean)this.sessionStore.renewSession(this.webContext));
        Assertions.assertTrue((boolean)this.sessionStore.buildFromTrackableSession(this.webContext, (Object)"trackable-session").isPresent());
        Assertions.assertTrue((boolean)this.sessionStore.getTrackableSession(this.webContext).isPresent());
    }

    @Test
    public void verifyCookieValue() {
        Assertions.assertTrue((boolean)this.sessionStore.get(this.webContext, "SessionAttribute1").isEmpty());
        Assertions.assertTrue((boolean)this.sessionStore.getSessionId(this.webContext, true).isEmpty());
        Assertions.assertThrows(InvalidCookieException.class, this::getDistributedSessionCookie);
        this.sessionStore.set(this.webContext, "SessionAttribute1", (Object)"AttributeValue1");
        Cookie cookie = this.getDistributedSessionCookie();
        String sessionCookieValue = this.cookieGenerator.getCasCookieValueManager().obtainCookieValue(cookie.getValue(), this.request);
        Assertions.assertNotNull((Object)sessionCookieValue);
        String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionCookieValue);
        Assertions.assertNotNull((Object)this.ticketRegistry.getTicket(ticketId));
        Assertions.assertFalse((boolean)this.sessionStore.get(this.webContext, "SessionAttribute1").isEmpty());
    }

    private Cookie getDistributedSessionCookie() {
        return Arrays.stream(this.response.getCookies()).filter(r -> r.getName().equals(this.cookieGenerator.getCookieName())).findFirst().orElseThrow(() -> new InvalidCookieException("Cookie not found"));
    }

    @Test
    public void verifySetGet() {
        Assertions.assertTrue((boolean)this.sessionStore.getSessionId(this.webContext, false).isEmpty());
        this.sessionStore.set(this.webContext, "attribute", (Object)"test");
        Assertions.assertTrue((boolean)this.sessionStore.getSessionId(this.webContext, false).isPresent());
        Optional value = this.sessionStore.get(this.webContext, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test", value.get());
        this.sessionStore.set(this.webContext, "attribute", (Object)"test2");
        value = this.sessionStore.get(this.webContext, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test2", value.get());
        this.sessionStore.set(this.webContext, "attribute", null);
        this.sessionStore.set(this.webContext, "attribute2", (Object)"test3");
        Assertions.assertFalse((boolean)this.sessionStore.get(this.webContext, "attribute").isPresent());
        value = this.sessionStore.get(this.webContext, "attribute2");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test3", value.get());
        Assertions.assertDoesNotThrow(() -> this.sessionStore.set(this.webContext, "not-serializable", (Object)new NoSerializable()));
        this.sessionStore.destroySession(this.webContext);
        value = this.sessionStore.get(this.webContext, "attribute");
        Assertions.assertTrue((boolean)value.isEmpty());
        Assertions.assertTrue((boolean)this.sessionStore.getSessionId(this.webContext, false).isPresent());
    }

    private static class NoSerializable {
        private NoSerializable() {
        }
    }
}

