/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.integration.pac4j.BaseSessionStoreTests;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={BaseSessionStoreTests.SharedTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Web")
public class DistributedJEESessionStoreTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private TicketFactory ticketFactory;

    @Test
    public void verifyTracking() {
        CookieSessionReplicationProperties cookie = this.casProperties.getSessionReplication().getCookie();
        CasCookieBuilder cookieGenerator = CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        DistributedJEESessionStore store = new DistributedJEESessionStore(this.centralAuthenticationService, this.ticketFactory, cookieGenerator);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)request.getSession());
        Assertions.assertFalse((boolean)store.renewSession((WebContext)context));
        Assertions.assertTrue((boolean)store.buildFromTrackableSession((WebContext)context, (Object)"trackable-session").isPresent());
        Assertions.assertTrue((boolean)store.getTrackableSession((WebContext)context).isPresent());
    }

    @Test
    public void verifySetGet() {
        CookieSessionReplicationProperties cookie = this.casProperties.getSessionReplication().getCookie();
        CasCookieBuilder cookieGenerator = CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        final DistributedJEESessionStore store = new DistributedJEESessionStore(this.centralAuthenticationService, this.ticketFactory, cookieGenerator);
        final JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)store.getSessionId((WebContext)context, false).isEmpty());
        store.set((WebContext)context, "attribute", (Object)"test");
        Assertions.assertTrue((boolean)store.getSessionId((WebContext)context, false).isPresent());
        Optional value = store.get((WebContext)context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test", value.get());
        store.set((WebContext)context, "attribute", (Object)"test2");
        value = store.get((WebContext)context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test2", value.get());
        store.set((WebContext)context, "attribute", null);
        store.set((WebContext)context, "attribute2", (Object)"test3");
        Assertions.assertFalse((boolean)store.get((WebContext)context, "attribute").isPresent());
        value = store.get((WebContext)context, "attribute2");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test3", value.get());
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() throws Throwable {
                store.set((WebContext)context, "not-serializable", (Object)new NoSerializable());
            }
        });
        store.destroySession((WebContext)context);
        value = store.get((WebContext)context, "attribute");
        Assertions.assertTrue((boolean)value.isEmpty());
        Assertions.assertTrue((boolean)store.getSessionId((WebContext)context, false).isPresent());
    }

    private static class NoSerializable {
        private NoSerializable() {
        }
    }
}

