/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketComponentSerializationConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.integration.pac4j.DistributedJEESessionStore;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={CasCoreTicketCatalogConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreTicketComponentSerializationConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreWebConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreConfiguration.class, CasCoreHttpConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreServicesConfiguration.class, CasCoreUtilConfiguration.class, MailSenderAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="Simple")
public class DistributedJEESessionStoreTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private TicketFactory ticketFactory;

    @Test
    public void verifyOperation() {
        SessionReplicationProperties.Cookie cookie = this.casProperties.getSessionReplication().getCookie();
        CasCookieBuilder cookieGenerator = CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        DistributedJEESessionStore store = new DistributedJEESessionStore(this.centralAuthenticationService, this.ticketFactory, cookieGenerator);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response, (SessionStore)store);
        Assertions.assertNotNull((Object)request.getSession());
        store.set(context, "attribute", (Object)"test");
        Optional value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test", value.get());
        store.set(context, "attribute", (Object)"test2");
        value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test2", value.get());
        store.set(context, "attribute", null);
        store.set(context, "attribute2", (Object)"test3");
        Assertions.assertFalse((boolean)store.get(context, "attribute").isPresent());
        value = store.get(context, "attribute2");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test3", value.get());
        store.destroySession(context);
        value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isEmpty());
    }
}

