/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import lombok.Generated;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DistributedJ2ESessionStore
extends JEESessionStore
implements HttpSessionListener,
LogoutPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedJ2ESessionStore.class);
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final String sessionCookieName;

    public Optional get(JEEContext context, String key) {
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (ticket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ticket.getProperties().get(key));
    }

    public void set(JEEContext context, String key, Object value) {
        TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        String id = this.getOrCreateSessionId(context);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (value instanceof Serializable) {
            properties.put(key, (Serializable)value);
        } else if (value != null) {
            LOGGER.trace("Object value [{}] assigned to [{}] is not serializable and may not be part of the ticket [{}]", new Object[]{value, key, id});
        }
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (value == null && ticket != null) {
            ticket.getProperties().remove(key);
            this.ticketRegistry.updateTicket((Ticket)ticket);
        } else if (ticket == null) {
            ticket = transientFactory.create(id, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
        } else {
            ticket.getProperties().putAll(properties);
            this.ticketRegistry.updateTicket((Ticket)ticket);
        }
    }

    private TransientSessionTicket getTransientSessionTicketForSession(JEEContext context) {
        String id = null;
        Collection cookies = context.getRequestCookies();
        if (cookies != null && !cookies.isEmpty()) {
            id = cookies.stream().filter(c -> this.sessionCookieName.equals(c.getName())).map(c -> c.getValue()).findFirst().orElse(null);
        }
        if (id != null) {
            LOGGER.trace("Session identifier found from {} cookie [{}]", (Object)this.sessionCookieName, (Object)id);
        } else {
            id = this.getOrCreateSessionId(context);
            LOGGER.trace("Session identifier created for HTTP session [{}]", (Object)id);
        }
        String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)id);
        LOGGER.trace("Fetching session ticket via identifier [{}]", (Object)ticketId);
        TransientSessionTicket ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
        if (ticket == null || ticket.isExpired()) {
            LOGGER.trace("The expiration policy for ticket id [{}] has expired the ticket", (Object)ticketId);
            return null;
        }
        return ticket;
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String id = se.getSession().getId();
        this.removeSessionTicket(id);
    }

    private void removeSessionTicket(String id) {
        String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)id);
        this.ticketRegistry.deleteTicket(ticketId);
    }

    public void handle(TicketGrantingTicket ticketGrantingTicket) {
        try {
            HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
            HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
            String id = this.getOrCreateSessionId(new JEEContext(request, response, (SessionStore)this));
            this.removeSessionTicket(id);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
    }

    @Generated
    public DistributedJ2ESessionStore(TicketRegistry ticketRegistry, TicketFactory ticketFactory, String sessionCookieName) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.sessionCookieName = sessionCookieName;
    }
}

