/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketComponentSerializationConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.integration.pac4j.DistributedJ2ESessionStore;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={CasCoreTicketCatalogConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreTicketComponentSerializationConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreWebConfiguration.class, CasCoreHttpConfiguration.class, CasCoreServicesConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DistributedJ2ESessionStoreTests {
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="defaultTicketFactory")
    private TicketFactory ticketFactory;

    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        DistributedJ2ESessionStore store = new DistributedJ2ESessionStore(this.ticketRegistry, this.ticketFactory, "JSESSIONID");
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response, (SessionStore)store);
        Assertions.assertNotNull((Object)request.getSession());
        store.set(context, "attribute", (Object)"test");
        Optional value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test", value.get());
        store.set(context, "attribute", (Object)"test2");
        value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test2", value.get());
        store.set(context, "attribute", null);
        store.set(context, "attribute2", (Object)"test3");
        Assertions.assertFalse((boolean)store.get(context, "attribute").isPresent());
        value = store.get(context, "attribute2");
        Assertions.assertTrue((boolean)value.isPresent());
        Assertions.assertEquals((Object)"test3", value.get());
        store.sessionDestroyed(new HttpSessionEvent(request.getSession()));
        store.handle((TicketGrantingTicket)new MockTicketGrantingTicket("casuser"));
        value = store.get(context, "attribute");
        Assertions.assertTrue((boolean)value.isEmpty());
    }
}

