/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.openid.OpenIdProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.handler.support.OpenIdCredentialsAuthenticationHandler;
import org.apereo.cas.support.openid.authentication.principal.OpenIdPrincipalResolver;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="openIdAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Deprecated(since="6.2.0")
public class OpenIdAuthenticationEventExecutionPlanConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;

    @Bean
    public AuthenticationHandler openIdCredentialsAuthenticationHandler() {
        OpenIdProperties openid = this.casProperties.getAuthn().getOpenid();
        return new OpenIdCredentialsAuthenticationHandler(openid.getName(), (ServicesManager)this.servicesManager.getObject(), this.openidPrincipalFactory(), (TicketRegistry)this.ticketRegistry.getObject(), openid.getOrder());
    }

    @Bean
    public OpenIdPrincipalResolver openIdPrincipalResolver() {
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        PersonDirectoryPrincipalResolverProperties principal = this.casProperties.getAuthn().getOpenid().getPrincipal();
        String principalAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)principal.getPrincipalAttribute(), (CharSequence)personDirectory.getPrincipalAttribute());
        return new OpenIdPrincipalResolver((IPersonAttributeDao)this.attributeRepository.getObject(), this.openidPrincipalFactory(), principal.isReturnNull() || personDirectory.isReturnNull(), principalAttribute, principal.isUseExistingPrincipalId() || personDirectory.isUseExistingPrincipalId(), principal.isAttributeResolutionEnabled(), StringUtils.commaDelimitedListToSet((String)principal.getActiveAttributeRepositoryIds()));
    }

    @ConditionalOnMissingBean(name={"openidPrincipalFactory"})
    @Bean
    public PrincipalFactory openidPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"openIdAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer openIdAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.openIdCredentialsAuthenticationHandler(), (PrincipalResolver)this.openIdPrincipalResolver());
    }
}

