/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceResponseBuilder;
import org.apereo.cas.support.openid.web.OpenIdProviderController;
import org.apereo.cas.support.openid.web.mvc.OpenIdValidateController;
import org.apereo.cas.support.openid.web.mvc.SmartOpenIdController;
import org.apereo.cas.support.openid.web.mvc.YadisController;
import org.apereo.cas.support.openid.web.support.OpenIdPostUrlHandlerMapping;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.DelegatingController;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactory;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.servlet.View;

@Configuration(value="openidConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Deprecated(since="6.2.0")
public class OpenIdConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdConfiguration.class);
    @Autowired
    @Qualifier(value="serviceValidationViewFactory")
    private ObjectProvider<ServiceValidationViewFactory> serviceValidationViewFactory;
    @Autowired
    @Qualifier(value="casOpenIdServiceSuccessView")
    private ObjectProvider<View> casOpenIdServiceSuccessView;
    @Autowired
    @Qualifier(value="casOpenIdServiceFailureView")
    private ObjectProvider<View> casOpenIdServiceFailureView;
    @Autowired
    @Qualifier(value="casOpenIdAssociationSuccessView")
    private ObjectProvider<View> casOpenIdAssociationSuccessView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ObjectProvider<ProxyHandler> proxy20Handler;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="requestedContextValidator")
    private ObjectProvider<RequestedAuthenticationContextValidator> requestedContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ObjectProvider<CasProtocolValidationSpecification> cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="serviceValidationAuthorizers")
    private ObjectProvider<ServiceTicketValidationAuthorizersExecutionPlan> validationAuthorizers;

    @Bean
    public SmartOpenIdController smartOpenIdAssociationController() {
        return new SmartOpenIdController(this.serverManager(), (View)this.casOpenIdAssociationSuccessView.getObject());
    }

    @RefreshScope
    @Bean
    public ServerManager serverManager() {
        ServerManager manager = new ServerManager();
        manager.setOPEndpointUrl(this.casProperties.getServer().getLoginUrl());
        manager.setEnforceRpId(this.casProperties.getAuthn().getOpenid().isEnforceRpId());
        manager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        LOGGER.trace("Creating openid server manager with OP endpoint [{}]", (Object)this.casProperties.getServer().getLoginUrl());
        return manager;
    }

    @ConditionalOnMissingBean(name={"openIdServiceResponseBuilder"})
    @Bean
    public ResponseBuilder openIdServiceResponseBuilder() {
        String openIdPrefixUrl = this.casProperties.getServer().getPrefix().concat("/openid");
        return new OpenIdServiceResponseBuilder(openIdPrefixUrl, this.serverManager(), (CentralAuthenticationService)this.centralAuthenticationService.getObject(), (ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"yadisController"})
    public YadisController yadisController() {
        return new YadisController();
    }

    @Bean
    @RefreshScope
    public OpenIdProviderController openIdProviderController() {
        return new OpenIdProviderController();
    }

    @Bean
    public OpenIdPostUrlHandlerMapping openIdPostUrlHandlerMapping() {
        ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().validationSpecifications(CollectionUtils.wrapSet((Object)((CasProtocolValidationSpecification)this.cas20WithoutProxyProtocolValidationSpecification.getObject()))).authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).argumentExtractor((ArgumentExtractor)this.argumentExtractor.getObject()).proxyHandler((ProxyHandler)this.proxy20Handler.getObject()).requestedContextValidator((RequestedAuthenticationContextValidator)this.requestedContextValidator.getObject()).authnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute()).validationAuthorizers((ServiceTicketValidationAuthorizersExecutionPlan)this.validationAuthorizers.getObject()).renewEnabled(this.casProperties.getSso().isRenewAuthnEnabled()).validationViewFactory((ServiceValidationViewFactory)this.serviceValidationViewFactory.getObject()).build();
        OpenIdValidateController c = new OpenIdValidateController(context, this.serverManager());
        DelegatingController controller = new DelegatingController();
        controller.setDelegates(CollectionUtils.wrapList((Object[])new AbstractDelegateController[]{this.smartOpenIdAssociationController(), c}));
        OpenIdPostUrlHandlerMapping m = new OpenIdPostUrlHandlerMapping();
        m.setOrder(1);
        Properties mappings = new Properties();
        mappings.put("/login", (Object)controller);
        m.setMappings(mappings);
        return m;
    }

    @Bean
    public ServiceValidationViewFactoryConfigurer openIdServiceValidationViewFactoryConfigurer() {
        return factory -> factory.registerView(OpenIdValidateController.class, Pair.of((Object)((View)this.casOpenIdServiceSuccessView.getObject()), (Object)((View)this.casOpenIdServiceFailureView.getObject())));
    }

    @Configuration(value="OpenIdProtocolViews")
    public class OpenIdProtocolViews {
        @Autowired
        @Qualifier(value="casProtocolViewFactory")
        private ObjectProvider<CasProtocolViewFactory> casProtocolViewFactory;

        @Bean
        @Scope(value="prototype")
        public View casOpenIdServiceFailureView() {
            return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(OpenIdConfiguration.this.applicationContext, "protocol/openid/casOpenIdServiceFailureView");
        }

        @Bean
        @Scope(value="prototype")
        public View casOpenIdServiceSuccessView() {
            return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(OpenIdConfiguration.this.applicationContext, "protocol/openid/casOpenIdServiceSuccessView");
        }

        @Bean
        @Scope(value="prototype")
        public View casOpenIdAssociationSuccessView() {
            return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(OpenIdConfiguration.this.applicationContext, "protocol/openid/casOpenIdAssociationSuccessView");
        }

        @Bean
        @Scope(value="prototype")
        public View openIdProviderView() {
            return ((CasProtocolViewFactory)this.casProtocolViewFactory.getObject()).create(OpenIdConfiguration.this.applicationContext, "protocol/openid/user");
        }
    }
}

