/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceFactory;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceResponseBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.openid4java.association.Association;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;

@Deprecated(since="6.2.0")
@Tag(value="Simple")
public class OpenIdServiceTests
extends AbstractOpenIdTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdServiceTests.class);
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "openIdService.json");
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private static final String OPEN_ID_PREFIX_URL = "http://openid.ja-sig.org/battags";
    private static final String RETURN_TO_URL = "http://www.ja-sig.org/?service=fa";
    private final MockHttpServletRequest request = new MockHttpServletRequest();
    @Autowired
    @Qualifier(value="serverManager")
    private ServerManager serverManager;
    @Autowired
    @Qualifier(value="openIdServiceFactory")
    private OpenIdServiceFactory openIdServiceFactory;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    private OpenIdService openIdService;
    private Association association;

    @BeforeEach
    public void initialize() throws Exception {
        this.request.addParameter("openid.identity", OPEN_ID_PREFIX_URL);
        this.request.addParameter("openid.return_to", RETURN_TO_URL);
        this.request.addParameter("openid.mode", "checkid_setup");
        this.association = this.serverManager.getSharedAssociations().generate("HMAC-SHA1", 2);
    }

    @Test
    public void verifySerializeAOpenIdServiceToJson() throws IOException {
        this.request.removeParameter("openid.assoc_handle");
        this.request.addParameter("openid.assoc_handle", this.association.getHandle());
        this.openIdService = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
        MAPPER.writeValue(JSON_FILE, (Object)this.openIdService);
        OpenIdService serviceRead = (OpenIdService)MAPPER.readValue(JSON_FILE, OpenIdService.class);
        Assertions.assertEquals((Object)this.openIdService, (Object)serviceRead);
    }

    @Test
    public void verifyGetResponse() {
        try {
            this.request.removeParameter("openid.assoc_handle");
            this.request.addParameter("openid.assoc_handle", this.association.getHandle());
            this.openIdService = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
            AuthenticationResult ctx = CoreAuthenticationTestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.authenticationSystemSupport, (Service)this.openIdService);
            String tgt = this.centralAuthenticationService.createTicketGrantingTicket(ctx).getId();
            String st = this.centralAuthenticationService.grantServiceTicket(tgt, (Service)this.openIdService, ctx).getId();
            this.centralAuthenticationService.validateServiceTicket(st, (Service)this.openIdService);
            Response response = new OpenIdServiceResponseBuilder(OPEN_ID_PREFIX_URL, this.serverManager, this.centralAuthenticationService, (ServicesManager)new DefaultServicesManager((ServiceRegistry)Mockito.mock(ServiceRegistry.class), (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class), new HashSet())).build((WebApplicationService)this.openIdService, "something", CoreAuthenticationTestUtils.getAuthentication());
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((Object)this.association.getHandle(), response.getAttributes().get("openid.assoc_handle"));
            Assertions.assertEquals((Object)RETURN_TO_URL, response.getAttributes().get("openid.return_to"));
            Assertions.assertEquals((Object)OPEN_ID_PREFIX_URL, response.getAttributes().get("openid.identity"));
            Response response2 = new OpenIdServiceResponseBuilder(OPEN_ID_PREFIX_URL, this.serverManager, this.centralAuthenticationService, (ServicesManager)new DefaultServicesManager((ServiceRegistry)Mockito.mock(ServiceRegistry.class), (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class), new HashSet())).build((WebApplicationService)this.openIdService, null, CoreAuthenticationTestUtils.getAuthentication());
            Assertions.assertEquals((Object)"cancel", response2.getAttributes().get("openid.mode"));
        }
        catch (Exception e) {
            LOGGER.debug("Exception during verification of service ticket", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyExpiredAssociationGetResponse() {
        try {
            this.request.removeParameter("openid.assoc_handle");
            this.request.addParameter("openid.assoc_handle", this.association.getHandle());
            this.openIdService = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
            AuthenticationResult ctx = CoreAuthenticationTestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.authenticationSystemSupport, (Service)this.openIdService);
            String tgt = this.centralAuthenticationService.createTicketGrantingTicket(ctx).getId();
            String st = this.centralAuthenticationService.grantServiceTicket(tgt, (Service)this.openIdService, ctx).getId();
            this.centralAuthenticationService.validateServiceTicket(st, (Service)this.openIdService);
            OpenIdServiceTests openIdServiceTests = this;
            synchronized (openIdServiceTests) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)"Could not wait long enough to check association expiry date");
                }
            }
            Response response = new OpenIdServiceResponseBuilder(OPEN_ID_PREFIX_URL, this.serverManager, this.centralAuthenticationService, (ServicesManager)new DefaultServicesManager((ServiceRegistry)Mockito.mock(ServiceRegistry.class), (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class), new HashSet())).build((WebApplicationService)this.openIdService, st, CoreAuthenticationTestUtils.getAuthentication());
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((int)2, (int)response.getAttributes().size());
            Assertions.assertEquals((Object)"cancel", response.getAttributes().get("openid.mode"));
        }
        catch (Exception e) {
            LOGGER.debug("Exception during verification of service ticket", (Throwable)e);
        }
    }

    @Test
    public void verifyEquals() {
        MockHttpServletRequest request1 = new MockHttpServletRequest();
        request1.addParameter("openid.identity", OPEN_ID_PREFIX_URL);
        request1.addParameter("openid.return_to", RETURN_TO_URL);
        request1.addParameter("openid.mode", "openid.checkid_setup");
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.addParameter("openid.identity", OPEN_ID_PREFIX_URL);
        request2.addParameter("openid.return_to", RETURN_TO_URL);
        OpenIdService o1 = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
        OpenIdService o2 = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
        Assertions.assertTrue((boolean)o1.equals((Object)o2));
        Assertions.assertFalse((boolean)o1.equals(new Object()));
    }
}

