/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.AbstractServiceValidateController;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OpenIdValidateController
extends AbstractServiceValidateController {
    private transient Logger logger = LoggerFactory.getLogger(OpenIdValidateController.class);
    private ServerManager serverManager;

    public void setServerManager(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String openIdMode = request.getParameter("openid.mode");
        if (StringUtils.equals((CharSequence)openIdMode, (CharSequence)"check_authentication")) {
            VerifyResponse message = (VerifyResponse)this.serverManager.verify(new ParameterList(request.getParameterMap()));
            HashMap parameters = new HashMap();
            parameters.putAll(message.getParameterMap());
            if (message.isSignatureVerified()) {
                this.logger.debug("Signature verification request successful.");
                return new ModelAndView(this.getSuccessView(), parameters);
            }
            this.logger.debug("Signature verification request unsuccessful.");
            return new ModelAndView(this.getFailureView(), parameters);
        }
        return super.handleRequestInternal(request, response);
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        String openIdMode = request.getParameter("openid.mode");
        if (StringUtils.equals((CharSequence)openIdMode, (CharSequence)"check_authentication")) {
            this.logger.info("Handling request. openid.mode : {}", (Object)openIdMode);
            return true;
        }
        this.logger.info("Cannot handle request. openid.mode : {}", (Object)openIdMode);
        return false;
    }
}

