/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.flow;

import org.apache.commons.lang.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdCredential;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.web.support.DefaultOpenIdUserNameExtractor;
import org.apereo.cas.support.openid.web.support.OpenIdUserNameExtractor;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class OpenIdSingleSignOnAction
extends AbstractNonInteractiveCredentialsAction {
    private OpenIdUserNameExtractor extractor = new DefaultOpenIdUserNameExtractor();
    private TicketRegistrySupport ticketRegistrySupport;

    public void setExtractor(OpenIdUserNameExtractor extractor) {
        this.extractor = extractor;
    }

    public void setTicketRegistrySupport(TicketRegistrySupport ticketRegistrySupport) {
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String openidIdentityParameter = context.getRequestParameters().get("openid.identity");
        String userName = this.getOpenIdSelectedIdentifier(context, ticketGrantingTicketId, openidIdentityParameter);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service instanceof OpenIdService && StringUtils.isBlank((String)userName)) {
            context.getFlowScope().remove("service");
        }
        if (StringUtils.isBlank((String)ticketGrantingTicketId) || StringUtils.isBlank((String)userName)) {
            return null;
        }
        return new OpenIdCredential(ticketGrantingTicketId, userName);
    }

    private String getOpenIdSelectedIdentifier(RequestContext context, String ticketGrantingTicketId, String openidIdentityParameter) {
        if ("http://specs.openid.net/auth/2.0/identifier_select".equals(openidIdentityParameter)) {
            context.getFlowScope().remove("openIdLocalId");
            Principal p = this.ticketRegistrySupport.getAuthenticatedPrincipalFrom(ticketGrantingTicketId);
            if (p != null) {
                return p.getId();
            }
            return "http://specs.openid.net/auth/2.0/identifier_select";
        }
        String userName = this.extractor.extractLocalUsernameFromUri(openidIdentityParameter);
        context.getFlowScope().put("openIdLocalId", (Object)userName);
        return userName;
    }
}

