/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.AbstractWebApplicationServiceResponseBuilder;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.util.ApplicationContextProvider;
import org.apereo.cas.validation.Assertion;
import org.openid4java.association.Association;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdServiceResponseBuilder
extends AbstractWebApplicationServiceResponseBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdServiceResponseBuilder.class);
    private static final long serialVersionUID = -4581238964007702423L;
    private ParameterList parameterList;
    private String openIdPrefixUrl;

    public OpenIdServiceResponseBuilder(ParameterList parameterList, String openIdPrefixUrl) {
        this.parameterList = parameterList;
        this.openIdPrefixUrl = openIdPrefixUrl;
    }

    public Response build(WebApplicationService webApplicationService, String ticketId) {
        ServerManager serverManager = (ServerManager)ApplicationContextProvider.getApplicationContext().getBean("serverManager", ServerManager.class);
        CentralAuthenticationService centralAuthenticationService = (CentralAuthenticationService)ApplicationContextProvider.getApplicationContext().getBean("centralAuthenticationService", CentralAuthenticationService.class);
        OpenIdService service = (OpenIdService)webApplicationService;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            parameters.put("openid.mode", "cancel");
            return this.buildRedirect((WebApplicationService)service, parameters);
        }
        Association association = this.getAssociation(serverManager);
        boolean associated = association != null;
        boolean associationValid = this.isAssociationValid(association);
        boolean successFullAuthentication = true;
        Assertion assertion = null;
        try {
            if (associated && associationValid) {
                assertion = centralAuthenticationService.validateServiceTicket(ticketId, (Service)service);
                LOGGER.debug("Validated openid ticket {} for {}", (Object)ticketId, (Object)service);
            } else if (!associated) {
                LOGGER.debug("Responding to non-associated mode. Service ticket {} must be validated by the RP", (Object)ticketId);
            } else {
                LOGGER.warn("Association does not exist or is not valid");
                successFullAuthentication = false;
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.error("Could not validate ticket : {}", (Object)e.getMessage(), (Object)e);
            successFullAuthentication = false;
        }
        String id = this.determineIdentity(service, assertion);
        return this.buildAuthenticationResponse(serverManager, service, parameters, associated, successFullAuthentication, id);
    }

    protected String determineIdentity(OpenIdService service, Assertion assertion) {
        String id = assertion != null && "http://specs.openid.net/auth/2.0/identifier_select".equals(service.getIdentity()) ? this.openIdPrefixUrl + '/' + assertion.getPrimaryAuthentication().getPrincipal().getId() : service.getIdentity();
        return id;
    }

    protected Response buildAuthenticationResponse(ServerManager serverManager, OpenIdService service, Map<String, String> parameters, boolean associated, boolean successFullAuthentication, String id) {
        Message response = serverManager.authResponse(this.parameterList, id, id, successFullAuthentication, true);
        parameters.putAll(response.getParameterMap());
        LOGGER.debug("Parameters passed for the OpenID response are {}", parameters.keySet());
        return this.buildRedirect((WebApplicationService)service, parameters);
    }

    protected Association getAssociation(ServerManager serverManager) {
        try {
            String assocHandle;
            AuthRequest authReq = AuthRequest.createAuthRequest((ParameterList)this.parameterList, (RealmVerifier)serverManager.getRealmVerifier());
            Map parameterMap = authReq.getParameterMap();
            if (parameterMap != null && !parameterMap.isEmpty() && (assocHandle = (String)parameterMap.get("openid.assoc_handle")) != null) {
                return serverManager.getSharedAssociations().load(assocHandle);
            }
        }
        catch (MessageException e) {
            LOGGER.error("Message exception : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    protected boolean isAssociationValid(Association association) {
        return association != null && !association.hasExpired();
    }
}

