/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceResponseBuilder;
import org.openid4java.message.ParameterList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class OpenIdServiceFactory
extends AbstractServiceFactory<OpenIdService> {
    private String openIdPrefixUrl;
    @Autowired
    private ApplicationContext applicationContext;

    public String getOpenIdPrefixUrl() {
        return this.openIdPrefixUrl;
    }

    public void setOpenIdPrefixUrl(String openIdPrefixUrl) {
        this.openIdPrefixUrl = openIdPrefixUrl;
    }

    public OpenIdService createService(HttpServletRequest request) {
        String service = request.getParameter("openid.return_to");
        String openIdIdentity = request.getParameter("openid.identity");
        if (openIdIdentity == null || !StringUtils.hasText((String)service)) {
            return null;
        }
        String id = OpenIdServiceFactory.cleanupUrl((String)service);
        String artifactId = request.getParameter("openid.assoc_handle");
        ParameterList paramList = new ParameterList(request.getParameterMap());
        OpenIdServiceResponseBuilder builder = new OpenIdServiceResponseBuilder(paramList, this.openIdPrefixUrl);
        return new OpenIdService(id, service, artifactId, openIdIdentity, (ResponseBuilder<WebApplicationService>)builder);
    }

    public OpenIdService createService(String id) {
        ParameterList paramList = new ParameterList();
        OpenIdServiceResponseBuilder builder = new OpenIdServiceResponseBuilder(paramList, this.openIdPrefixUrl);
        return new OpenIdService(id, id, null, this.openIdPrefixUrl, (ResponseBuilder<WebApplicationService>)builder);
    }
}

