/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.openid.authentication.handler.support.OpenIdCredentialsAuthenticationHandler;
import org.apereo.cas.support.openid.authentication.principal.OpenIdPrincipalResolver;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceFactory;
import org.apereo.cas.support.openid.web.OpenIdProviderController;
import org.apereo.cas.support.openid.web.flow.OpenIdSingleSignOnAction;
import org.apereo.cas.support.openid.web.mvc.OpenIdValidateController;
import org.apereo.cas.support.openid.web.mvc.SmartOpenIdController;
import org.apereo.cas.support.openid.web.support.DefaultOpenIdUserNameExtractor;
import org.apereo.cas.support.openid.web.support.OpenIdPostUrlHandlerMapping;
import org.apereo.cas.support.openid.web.support.OpenIdUserNameExtractor;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.validation.ValidationSpecification;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.DelegatingController;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;
import org.springframework.webflow.execution.Action;

@Configuration(value="openidConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OpenIdConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdConfiguration.class);
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="casOpenIdServiceSuccessView")
    private View casOpenIdServiceSuccessView;
    @Autowired
    @Qualifier(value="casOpenIdServiceFailureView")
    private View casOpenIdServiceFailureView;
    @Autowired
    @Qualifier(value="casOpenIdAssociationSuccessView")
    private View casOpenIdAssociationSuccessView;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;
    @Autowired
    @Qualifier(value="serviceTicketUniqueIdGenerator")
    private UniqueTicketIdGenerator serviceTicketUniqueIdGenerator;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="defaultArgumentExtractor")
    private ArgumentExtractor argumentExtractor;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="uniqueIdGeneratorsMap")
    private Map uniqueIdGeneratorsMap;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;

    @Bean
    public DelegatingController openidDelegatingController() {
        DelegatingController controller = new DelegatingController();
        controller.setDelegates(Lists.newArrayList((Object[])new AbstractDelegateController[]{this.smartOpenIdAssociationController(), this.openIdValidateController()}));
        return controller;
    }

    @Bean
    public AbstractDelegateController smartOpenIdAssociationController() {
        SmartOpenIdController b = new SmartOpenIdController();
        b.setServerManager(this.serverManager());
        b.setSuccessView(this.casOpenIdAssociationSuccessView);
        return b;
    }

    @Bean
    public AbstractDelegateController openIdValidateController() {
        OpenIdValidateController c = new OpenIdValidateController();
        c.setServerManager(this.serverManager());
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.casOpenIdServiceSuccessView);
        c.setFailureView(this.casOpenIdServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(this.argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView);
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @RefreshScope
    @Bean
    public ServerManager serverManager() {
        ServerManager manager = new ServerManager();
        manager.setOPEndpointUrl(this.casProperties.getServer().getLoginUrl());
        manager.setEnforceRpId(this.casProperties.getAuthn().getOpenid().isEnforceRpId());
        manager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        LOGGER.info("Creating openid server manager with OP endpoint {}", (Object)this.casProperties.getServer().getLoginUrl());
        return manager;
    }

    @Bean
    public AuthenticationHandler openIdCredentialsAuthenticationHandler() {
        OpenIdCredentialsAuthenticationHandler h = new OpenIdCredentialsAuthenticationHandler();
        h.setTicketRegistry(this.ticketRegistry);
        h.setPrincipalFactory(this.openidPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        return h;
    }

    @Bean
    public OpenIdPrincipalResolver openIdPrincipalResolver() {
        OpenIdPrincipalResolver r = new OpenIdPrincipalResolver();
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getOpenid().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getOpenid().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.openidPrincipalFactory());
        return r;
    }

    @Bean
    public PrincipalFactory openidPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public OpenIdServiceFactory openIdServiceFactory() {
        OpenIdServiceFactory f = new OpenIdServiceFactory();
        f.setOpenIdPrefixUrl(this.casProperties.getServer().getPrefix().concat("/openid"));
        return f;
    }

    @Bean
    @RefreshScope
    public OpenIdProviderController openIdProviderController() {
        return new OpenIdProviderController();
    }

    @Bean
    public Action openIdSingleSignOnAction() {
        OpenIdSingleSignOnAction a = new OpenIdSingleSignOnAction();
        a.setExtractor(this.defaultOpenIdUserNameExtractor());
        a.setTicketRegistrySupport(this.ticketRegistrySupport);
        a.setAdaptiveAuthenticationPolicy(this.adaptiveAuthenticationPolicy);
        a.setInitialAuthenticationAttemptWebflowEventResolver(this.initialAuthenticationAttemptWebflowEventResolver);
        a.setServiceTicketRequestWebflowEventResolver(this.serviceTicketRequestWebflowEventResolver);
        return a;
    }

    @Bean
    public OpenIdUserNameExtractor defaultOpenIdUserNameExtractor() {
        return new DefaultOpenIdUserNameExtractor();
    }

    @Bean
    public OpenIdPostUrlHandlerMapping openIdPostUrlHandlerMapping() {
        OpenIdPostUrlHandlerMapping m = new OpenIdPostUrlHandlerMapping();
        m.setOrder(1);
        Properties mappings = new Properties();
        mappings.put("/login", (Object)this.openidDelegatingController());
        m.setMappings(mappings);
        return m;
    }

    @PostConstruct
    protected void initializeRootApplicationContext() {
        this.authenticationHandlersResolvers.put(this.openIdCredentialsAuthenticationHandler(), this.openIdPrincipalResolver());
        this.uniqueIdGeneratorsMap.put(OpenIdService.class.getCanonicalName(), this.serviceTicketUniqueIdGenerator);
        this.argumentExtractor.getServiceFactories().add(0, this.openIdServiceFactory());
    }
}

