/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.support;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.web.support.OpenIdPostUrlHandlerMapping;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;

public class OpenIdPostUrlHandlerMappingTests
extends AbstractOpenIdTests {
    @Autowired
    private OpenIdPostUrlHandlerMapping handlerMapping;

    @Test
    public void verifyNoMatch() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/hello");
        Assert.assertNull((Object)this.handlerMapping.lookupHandler("/hello", (HttpServletRequest)request));
    }

    @Test
    public void verifyImproperMatch() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/hello");
        Assert.assertNull((Object)this.handlerMapping.lookupHandler("/login", (HttpServletRequest)request));
    }

    @Test
    public void verifyProperMatchWrongMethod() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/login");
        request.setMethod("GET");
        Assert.assertNull((Object)this.handlerMapping.lookupHandler("/login", (HttpServletRequest)request));
    }

    @Test
    public void verifyProperMatchCorrectMethodNoParam() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/login");
        request.setMethod("POST");
        Assert.assertNull((Object)this.handlerMapping.lookupHandler("/login", (HttpServletRequest)request));
    }

    @Test
    public void verifyProperMatchCorrectMethodWithParam() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/login");
        request.setMethod("POST");
        request.setParameter("openid.mode", "check_authentication");
        Assert.assertNotNull((Object)this.handlerMapping.lookupHandler("/login", (HttpServletRequest)request));
    }
}

