/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.mvc;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.web.mvc.SmartOpenIdController;
import org.junit.Assert;
import org.junit.Test;
import org.openid4java.server.ServerManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class SmartOpenIdControllerTests
extends AbstractOpenIdTests {
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private HttpServletResponse response = new MockHttpServletResponse();
    @Autowired
    private ServerManager manager;
    @Autowired
    private SmartOpenIdController smartOpenIdController;

    @Test
    public void verifyCanHandle() {
        this.request.addParameter("openid.mode", "associate");
        boolean canHandle = this.smartOpenIdController.canHandle((HttpServletRequest)this.request, this.response);
        this.request.removeParameter("openid.mode");
        Assert.assertEquals((Object)true, (Object)canHandle);
    }

    @Test
    public void verifyCannotHandle() {
        this.request.addParameter("openid.mode", "anythingElse");
        boolean canHandle = this.smartOpenIdController.canHandle((HttpServletRequest)this.request, this.response);
        this.request.removeParameter("openid.mode");
        Assert.assertEquals((Object)false, (Object)canHandle);
    }

    @Test
    public void verifyGetAssociationResponse() {
        this.request.addParameter("openid.mode", "associate");
        this.request.addParameter("openid.session_type", "DH-SHA1");
        this.request.addParameter("openid.assoc_type", "HMAC-SHA1");
        this.request.addParameter("openid.dh_consumer_public", "NzKoFMyrzFn/5iJFPdX6MVvNA/BChV1/sJdnYbupDn7ptn+cerwEzyFfWFx25KsoLSkxQCaSMmYtc1GPy/2GI1BSKSDhpdJmDBbQRa/9Gs+giV/5fHcz/mHz8sREc7RTGI+0Ka9230arwrWt0fnoaJLRKEGUsmFR71rCo4EUOew=");
        Map assocResponse = this.smartOpenIdController.getAssociationResponse((HttpServletRequest)this.request);
        Assert.assertTrue((boolean)assocResponse.containsKey("assoc_handle"));
        Assert.assertTrue((boolean)assocResponse.containsKey("expires_in"));
        Assert.assertTrue((boolean)assocResponse.containsKey("dh_server_public"));
        Assert.assertTrue((boolean)assocResponse.containsKey("enc_mac_key"));
        this.request.removeParameter("openid.mode");
    }
}

