/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceFactory;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

public class OpenIdSingleSignOnActionTests
extends AbstractOpenIdTests {
    @Autowired
    @Qualifier(value="openIdSingleSignOnAction")
    private Action action;
    @Autowired
    private TicketRegistry ticketRegistry;

    @Test
    public void verifyNoTgt() throws Exception {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse()));
        Assert.assertEquals((Object)"error", (Object)this.action.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyNoService() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Event event = this.action.execute((RequestContext)context);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)"error", (Object)this.action.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyBadUsername() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("openid.identity", "fablah");
        request.setParameter("openid.return_to", "http://www.cnn.com");
        OpenIdServiceFactory factory = new OpenIdServiceFactory();
        OpenIdService service = factory.createService((HttpServletRequest)request);
        context.getFlowScope().put("service", (Object)service);
        context.getFlowScope().put("ticketGrantingTicketId", (Object)"tgtId");
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assert.assertEquals((Object)"error", (Object)this.action.execute((RequestContext)context).getId());
    }

    @Test
    public void verifySuccessfulServiceTicket() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        Authentication authentication = TestUtils.getAuthentication((String)"scootman28");
        TicketGrantingTicketImpl t = new TicketGrantingTicketImpl("TGT-11", authentication, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        this.ticketRegistry.addTicket((Ticket)t);
        request.setParameter("openid.identity", "http://openid.aol.com/scootman28");
        request.setParameter("openid.return_to", "http://www.cnn.com");
        OpenIdService service = new OpenIdServiceFactory().createService((HttpServletRequest)request);
        context.getFlowScope().put("service", (Object)service);
        context.getFlowScope().put("ticketGrantingTicketId", (Object)t.getId());
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Assert.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
    }
}

