/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openid4java.association.Association;
import org.springframework.mock.web.MockHttpServletRequest;

public class OpenIdServiceTests
extends AbstractOpenIdTests {
    private OpenIdService openIdService;
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private Association association;

    @Before
    public void setUp() throws Exception {
        this.request.addParameter("openid.identity", "http://openid.ja-sig.org/battags");
        this.request.addParameter("openid.return_to", "http://www.ja-sig.org/?service=fa");
        this.request.addParameter("openid.mode", "checkid_setup");
        this.association = this.serverManager.getSharedAssociations().generate("HMAC-SHA1", 2);
    }

    @Test
    public void verifyGetResponse() {
        try {
            this.request.removeParameter("openid.assoc_handle");
            this.request.addParameter("openid.assoc_handle", this.association.getHandle());
            this.openIdService = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
            AuthenticationResult ctx = TestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.openIdService);
            String tgt = this.centralAuthenticationService.createTicketGrantingTicket(ctx).getId();
            String st = this.centralAuthenticationService.grantServiceTicket(tgt, (Service)this.openIdService, ctx).getId();
            this.centralAuthenticationService.validateServiceTicket(st, (Service)this.openIdService);
            Response response = this.openIdService.getResponse(st);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)this.association.getHandle(), response.getAttributes().get("openid.assoc_handle"));
            Assert.assertEquals((Object)"http://www.ja-sig.org/?service=fa", response.getAttributes().get("openid.return_to"));
            Assert.assertEquals((Object)"http://openid.ja-sig.org/battags", response.getAttributes().get("openid.identity"));
            Response response2 = this.openIdService.getResponse(null);
            Assert.assertEquals((Object)"cancel", response2.getAttributes().get("openid.mode"));
        }
        catch (Exception e) {
            this.logger.debug("Exception during verification of service ticket", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyExpiredAssociationGetResponse() {
        try {
            this.request.removeParameter("openid.assoc_handle");
            this.request.addParameter("openid.assoc_handle", this.association.getHandle());
            this.openIdService = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
            AuthenticationResult ctx = TestUtils.getAuthenticationResult((AuthenticationSystemSupport)this.getAuthenticationSystemSupport(), (Service)this.openIdService);
            String tgt = this.centralAuthenticationService.createTicketGrantingTicket(ctx).getId();
            String st = this.centralAuthenticationService.grantServiceTicket(tgt, (Service)this.openIdService, ctx).getId();
            this.centralAuthenticationService.validateServiceTicket(st, (Service)this.openIdService);
            OpenIdServiceTests openIdServiceTests = this;
            synchronized (openIdServiceTests) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Could not wait long enough to check association expiry date");
                }
            }
            Response response = this.openIdService.getResponse(st);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)2L, (long)response.getAttributes().size());
            Assert.assertEquals((Object)"cancel", response.getAttributes().get("openid.mode"));
        }
        catch (Exception e) {
            this.logger.debug("Exception during verification of service ticket", (Throwable)e);
        }
    }

    @Test
    public void verifyEquals() {
        MockHttpServletRequest request1 = new MockHttpServletRequest();
        request1.addParameter("openid.identity", "http://openid.ja-sig.org/battags");
        request1.addParameter("openid.return_to", "http://www.ja-sig.org/?service=fa");
        request1.addParameter("openid.mode", "openid.checkid_setup");
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        request2.addParameter("openid.identity", "http://openid.ja-sig.org/battags");
        request2.addParameter("openid.return_to", "http://www.ja-sig.org/?service=fa");
        OpenIdService o1 = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
        OpenIdService o2 = this.openIdServiceFactory.createService((HttpServletRequest)this.request);
        Assert.assertTrue((boolean)o1.equals((Object)o2));
        Assert.assertFalse((boolean)o1.equals(new Object()));
    }
}

