/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.support.openid.authentication.principal.OpenIdService;
import org.apereo.cas.support.openid.authentication.principal.OpenIdServiceFactory;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class OpenIdServiceFactoryTests {
    @Test
    public void verifyServiceCreationSuccessfullyById() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("openid.return_to", "test");
        request.addParameter("openid.identity", "identity");
        OpenIdServiceFactory factory = new OpenIdServiceFactory();
        OpenIdService service = factory.createService((HttpServletRequest)request);
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void verifyServiceCreationMissingReturn() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("openid.identity", "identity");
        OpenIdServiceFactory factory = new OpenIdServiceFactory();
        OpenIdService service = factory.createService((HttpServletRequest)request);
        Assert.assertNull((Object)service);
    }

    @Test
    public void verifyServiceCreationMissingId() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("openid.return_to", "test");
        OpenIdServiceFactory factory = new OpenIdServiceFactory();
        OpenIdService service = factory.createService((HttpServletRequest)request);
        Assert.assertNull((Object)service);
    }
}

