/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.openid.authentication.handler.support;

import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.support.openid.AbstractOpenIdTests;
import org.apereo.cas.support.openid.authentication.handler.support.OpenIdCredentialsAuthenticationHandler;
import org.apereo.cas.support.openid.authentication.principal.OpenIdCredential;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenIdCredentialsAuthenticationHandlerTests
extends AbstractOpenIdTests {
    @Autowired
    private OpenIdCredentialsAuthenticationHandler openIdCredentialsAuthenticationHandler;
    @Autowired
    private TicketRegistry ticketRegistry;

    @Test
    public void verifySupports() {
        Assert.assertTrue((boolean)this.openIdCredentialsAuthenticationHandler.supports((Credential)new OpenIdCredential("test", "test")));
        Assert.assertFalse((boolean)this.openIdCredentialsAuthenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyTGTWithSameId() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test");
        TicketGrantingTicket t = this.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        Assert.assertEquals((Object)"test", (Object)this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c).getPrincipal().getId());
    }

    @Test(expected=FailedLoginException.class)
    public void verifyTGTThatIsExpired() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test");
        TicketGrantingTicket t = this.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        t.markTicketExpired();
        this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c);
    }

    @Test(expected=FailedLoginException.class)
    public void verifyTGTWithDifferentId() throws Exception {
        OpenIdCredential c = new OpenIdCredential("test", "test1");
        TicketGrantingTicket t = this.getTicketGrantingTicket();
        this.ticketRegistry.addTicket((Ticket)t);
        this.openIdCredentialsAuthenticationHandler.authenticate((Credential)c);
    }

    protected TicketGrantingTicket getTicketGrantingTicket() {
        return new TicketGrantingTicketImpl("test", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy());
    }
}

