/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="OIDC")
class PairwiseOidcRegisteredServiceUsernameAttributeProviderTests {
    PairwiseOidcRegisteredServiceUsernameAttributeProviderTests() {
    }

    @Test
    void verifyNonCompatibleService() throws Throwable {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService((String)"verifyUsernameByPrincipalAttributeWithMapping")).principal(RegisteredServiceTestUtils.getPrincipal((String)"casuser")).applicationContext((ApplicationContext)applicationContext).build();
        String uid = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
    }

    @Test
    void verifyUndefinedOrPublicSubjectType() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        OidcRegisteredService registeredService = new OidcRegisteredService();
        registeredService.setName("verifyUndefinedOrPublicSubjectType");
        registeredService.setServiceId("testId");
        registeredService.setClientId("clientid");
        registeredService.setClientSecret("something");
        registeredService.setSubjectType("");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service((Service)RegisteredServiceTestUtils.getService()).principal(RegisteredServiceTestUtils.getPrincipal((String)"casuser")).applicationContext((ApplicationContext)applicationContext).build();
        String uid = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
        registeredService.setSubjectType(null);
        uid = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
        registeredService.setSubjectType(OidcSubjectTypes.PUBLIC.getType());
        uid = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
    }

    @Test
    void verifySubjectType() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        provider.setPersistentIdGenerator((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("cpaOl1pwGZ439!!"));
        OidcRegisteredService registeredService = new OidcRegisteredService();
        registeredService.setName("verifySubjectType");
        registeredService.setSectorIdentifierUri("https://sso.example.org/oidc");
        registeredService.setClientId("clientid");
        registeredService.setClientSecret("something");
        registeredService.setSubjectType(OidcSubjectTypes.PAIRWISE.getType());
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service((Service)RegisteredServiceTestUtils.getService()).principal(RegisteredServiceTestUtils.getPrincipal((String)"casuser")).applicationContext((ApplicationContext)applicationContext).build();
        String uid = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"9IOlxFj2XgfhkNJieynbw+Pm+4E=", (Object)uid);
        registeredService.setSectorIdentifierUri(null);
        registeredService.setServiceId("https://sso.example.org/oidc");
        String uid1 = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)uid1, (Object)uid);
    }
}

