/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.DurationCapable;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.RegisteredServiceOidcIdTokenExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;

public class OidcRegisteredService
extends OAuthRegisteredService {
    private static final long serialVersionUID = 1310899699465091444L;
    @ExpressionLanguageCapable
    private String jwks;
    private String jwksKeyId;
    @DurationCapable
    private String jwksCacheDuration;
    private String tokenEndpointAuthenticationMethod = "client_secret_basic";
    @JacksonInject(value="signIdToken")
    private boolean signIdToken = true;
    @JacksonInject(value="encryptIdToken")
    private boolean encryptIdToken;
    private String idTokenEncryptionAlg;
    private String idTokenSigningAlg;
    private String userInfoSigningAlg;
    private String userInfoEncryptedResponseAlg;
    private String userInfoEncryptedResponseEncoding;
    private String idTokenEncryptionEncoding;
    private String idTokenIssuer;
    private String sectorIdentifierUri;
    private String applicationType = "web";
    private String subjectType = OidcSubjectTypes.PUBLIC.getType();
    private long clientSecretExpiration;
    private RegisteredServiceOidcIdTokenExpirationPolicy idTokenExpirationPolicy;

    public String getSubjectType() {
        if (StringUtils.isBlank((CharSequence)this.subjectType)) {
            return OidcSubjectTypes.PUBLIC.getType();
        }
        return this.subjectType;
    }

    @JsonIgnore
    public int getEvaluationPriority() {
        return 1;
    }

    @JsonIgnore
    public String getFriendlyName() {
        return "OpenID Connect Relying Party";
    }

    @JsonIgnore
    public void markAsDynamicallyRegistered() {
        this.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.OIDC_DYNAMIC_CLIENT_REGISTRATION.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{Boolean.TRUE.toString()}));
        this.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.OIDC_DYNAMIC_CLIENT_REGISTRATION_DATE.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{LocalDateTime.now(ZoneOffset.UTC).toString()}));
    }

    @Generated
    public String toString() {
        return "OidcRegisteredService(super=" + super.toString() + ", jwks=" + this.jwks + ", jwksKeyId=" + this.jwksKeyId + ", jwksCacheDuration=" + this.jwksCacheDuration + ", tokenEndpointAuthenticationMethod=" + this.tokenEndpointAuthenticationMethod + ", signIdToken=" + this.signIdToken + ", encryptIdToken=" + this.encryptIdToken + ", idTokenEncryptionAlg=" + this.idTokenEncryptionAlg + ", idTokenSigningAlg=" + this.idTokenSigningAlg + ", userInfoSigningAlg=" + this.userInfoSigningAlg + ", userInfoEncryptedResponseAlg=" + this.userInfoEncryptedResponseAlg + ", userInfoEncryptedResponseEncoding=" + this.userInfoEncryptedResponseEncoding + ", idTokenEncryptionEncoding=" + this.idTokenEncryptionEncoding + ", idTokenIssuer=" + this.idTokenIssuer + ", sectorIdentifierUri=" + this.sectorIdentifierUri + ", applicationType=" + this.applicationType + ", subjectType=" + this.subjectType + ", clientSecretExpiration=" + this.clientSecretExpiration + ", idTokenExpirationPolicy=" + String.valueOf(this.idTokenExpirationPolicy) + ")";
    }

    @Generated
    public String getJwks() {
        return this.jwks;
    }

    @Generated
    public String getJwksKeyId() {
        return this.jwksKeyId;
    }

    @Generated
    public String getJwksCacheDuration() {
        return this.jwksCacheDuration;
    }

    @Generated
    public String getTokenEndpointAuthenticationMethod() {
        return this.tokenEndpointAuthenticationMethod;
    }

    @Generated
    public boolean isSignIdToken() {
        return this.signIdToken;
    }

    @Generated
    public boolean isEncryptIdToken() {
        return this.encryptIdToken;
    }

    @Generated
    public String getIdTokenEncryptionAlg() {
        return this.idTokenEncryptionAlg;
    }

    @Generated
    public String getIdTokenSigningAlg() {
        return this.idTokenSigningAlg;
    }

    @Generated
    public String getUserInfoSigningAlg() {
        return this.userInfoSigningAlg;
    }

    @Generated
    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    @Generated
    public String getUserInfoEncryptedResponseEncoding() {
        return this.userInfoEncryptedResponseEncoding;
    }

    @Generated
    public String getIdTokenEncryptionEncoding() {
        return this.idTokenEncryptionEncoding;
    }

    @Generated
    public String getIdTokenIssuer() {
        return this.idTokenIssuer;
    }

    @Generated
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public long getClientSecretExpiration() {
        return this.clientSecretExpiration;
    }

    @Generated
    public RegisteredServiceOidcIdTokenExpirationPolicy getIdTokenExpirationPolicy() {
        return this.idTokenExpirationPolicy;
    }

    @Generated
    public OidcRegisteredService setJwks(String jwks) {
        this.jwks = jwks;
        return this;
    }

    @Generated
    public OidcRegisteredService setJwksKeyId(String jwksKeyId) {
        this.jwksKeyId = jwksKeyId;
        return this;
    }

    @Generated
    public OidcRegisteredService setJwksCacheDuration(String jwksCacheDuration) {
        this.jwksCacheDuration = jwksCacheDuration;
        return this;
    }

    @Generated
    public OidcRegisteredService setTokenEndpointAuthenticationMethod(String tokenEndpointAuthenticationMethod) {
        this.tokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
        return this;
    }

    @JacksonInject(value="signIdToken")
    @Generated
    public OidcRegisteredService setSignIdToken(boolean signIdToken) {
        this.signIdToken = signIdToken;
        return this;
    }

    @JacksonInject(value="encryptIdToken")
    @Generated
    public OidcRegisteredService setEncryptIdToken(boolean encryptIdToken) {
        this.encryptIdToken = encryptIdToken;
        return this;
    }

    @Generated
    public OidcRegisteredService setIdTokenEncryptionAlg(String idTokenEncryptionAlg) {
        this.idTokenEncryptionAlg = idTokenEncryptionAlg;
        return this;
    }

    @Generated
    public OidcRegisteredService setIdTokenSigningAlg(String idTokenSigningAlg) {
        this.idTokenSigningAlg = idTokenSigningAlg;
        return this;
    }

    @Generated
    public OidcRegisteredService setUserInfoSigningAlg(String userInfoSigningAlg) {
        this.userInfoSigningAlg = userInfoSigningAlg;
        return this;
    }

    @Generated
    public OidcRegisteredService setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
        return this;
    }

    @Generated
    public OidcRegisteredService setUserInfoEncryptedResponseEncoding(String userInfoEncryptedResponseEncoding) {
        this.userInfoEncryptedResponseEncoding = userInfoEncryptedResponseEncoding;
        return this;
    }

    @Generated
    public OidcRegisteredService setIdTokenEncryptionEncoding(String idTokenEncryptionEncoding) {
        this.idTokenEncryptionEncoding = idTokenEncryptionEncoding;
        return this;
    }

    @Generated
    public OidcRegisteredService setIdTokenIssuer(String idTokenIssuer) {
        this.idTokenIssuer = idTokenIssuer;
        return this;
    }

    @Generated
    public OidcRegisteredService setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
        return this;
    }

    @Generated
    public OidcRegisteredService setApplicationType(String applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    @Generated
    public OidcRegisteredService setSubjectType(String subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    @Generated
    public OidcRegisteredService setClientSecretExpiration(long clientSecretExpiration) {
        this.clientSecretExpiration = clientSecretExpiration;
        return this;
    }

    @Generated
    public OidcRegisteredService setIdTokenExpirationPolicy(RegisteredServiceOidcIdTokenExpirationPolicy idTokenExpirationPolicy) {
        this.idTokenExpirationPolicy = idTokenExpirationPolicy;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcRegisteredService)) {
            return false;
        }
        OidcRegisteredService other = (OidcRegisteredService)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.signIdToken != other.signIdToken) {
            return false;
        }
        if (this.encryptIdToken != other.encryptIdToken) {
            return false;
        }
        if (this.clientSecretExpiration != other.clientSecretExpiration) {
            return false;
        }
        String this$jwks = this.jwks;
        String other$jwks = other.jwks;
        if (this$jwks == null ? other$jwks != null : !this$jwks.equals(other$jwks)) {
            return false;
        }
        String this$jwksKeyId = this.jwksKeyId;
        String other$jwksKeyId = other.jwksKeyId;
        if (this$jwksKeyId == null ? other$jwksKeyId != null : !this$jwksKeyId.equals(other$jwksKeyId)) {
            return false;
        }
        String this$jwksCacheDuration = this.jwksCacheDuration;
        String other$jwksCacheDuration = other.jwksCacheDuration;
        if (this$jwksCacheDuration == null ? other$jwksCacheDuration != null : !this$jwksCacheDuration.equals(other$jwksCacheDuration)) {
            return false;
        }
        String this$tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        String other$tokenEndpointAuthenticationMethod = other.tokenEndpointAuthenticationMethod;
        if (this$tokenEndpointAuthenticationMethod == null ? other$tokenEndpointAuthenticationMethod != null : !this$tokenEndpointAuthenticationMethod.equals(other$tokenEndpointAuthenticationMethod)) {
            return false;
        }
        String this$idTokenEncryptionAlg = this.idTokenEncryptionAlg;
        String other$idTokenEncryptionAlg = other.idTokenEncryptionAlg;
        if (this$idTokenEncryptionAlg == null ? other$idTokenEncryptionAlg != null : !this$idTokenEncryptionAlg.equals(other$idTokenEncryptionAlg)) {
            return false;
        }
        String this$idTokenSigningAlg = this.idTokenSigningAlg;
        String other$idTokenSigningAlg = other.idTokenSigningAlg;
        if (this$idTokenSigningAlg == null ? other$idTokenSigningAlg != null : !this$idTokenSigningAlg.equals(other$idTokenSigningAlg)) {
            return false;
        }
        String this$userInfoSigningAlg = this.userInfoSigningAlg;
        String other$userInfoSigningAlg = other.userInfoSigningAlg;
        if (this$userInfoSigningAlg == null ? other$userInfoSigningAlg != null : !this$userInfoSigningAlg.equals(other$userInfoSigningAlg)) {
            return false;
        }
        String this$userInfoEncryptedResponseAlg = this.userInfoEncryptedResponseAlg;
        String other$userInfoEncryptedResponseAlg = other.userInfoEncryptedResponseAlg;
        if (this$userInfoEncryptedResponseAlg == null ? other$userInfoEncryptedResponseAlg != null : !this$userInfoEncryptedResponseAlg.equals(other$userInfoEncryptedResponseAlg)) {
            return false;
        }
        String this$userInfoEncryptedResponseEncoding = this.userInfoEncryptedResponseEncoding;
        String other$userInfoEncryptedResponseEncoding = other.userInfoEncryptedResponseEncoding;
        if (this$userInfoEncryptedResponseEncoding == null ? other$userInfoEncryptedResponseEncoding != null : !this$userInfoEncryptedResponseEncoding.equals(other$userInfoEncryptedResponseEncoding)) {
            return false;
        }
        String this$idTokenEncryptionEncoding = this.idTokenEncryptionEncoding;
        String other$idTokenEncryptionEncoding = other.idTokenEncryptionEncoding;
        if (this$idTokenEncryptionEncoding == null ? other$idTokenEncryptionEncoding != null : !this$idTokenEncryptionEncoding.equals(other$idTokenEncryptionEncoding)) {
            return false;
        }
        String this$idTokenIssuer = this.idTokenIssuer;
        String other$idTokenIssuer = other.idTokenIssuer;
        if (this$idTokenIssuer == null ? other$idTokenIssuer != null : !this$idTokenIssuer.equals(other$idTokenIssuer)) {
            return false;
        }
        String this$sectorIdentifierUri = this.sectorIdentifierUri;
        String other$sectorIdentifierUri = other.sectorIdentifierUri;
        if (this$sectorIdentifierUri == null ? other$sectorIdentifierUri != null : !this$sectorIdentifierUri.equals(other$sectorIdentifierUri)) {
            return false;
        }
        String this$applicationType = this.applicationType;
        String other$applicationType = other.applicationType;
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$subjectType = this.subjectType;
        String other$subjectType = other.subjectType;
        if (this$subjectType == null ? other$subjectType != null : !this$subjectType.equals(other$subjectType)) {
            return false;
        }
        RegisteredServiceOidcIdTokenExpirationPolicy this$idTokenExpirationPolicy = this.idTokenExpirationPolicy;
        RegisteredServiceOidcIdTokenExpirationPolicy other$idTokenExpirationPolicy = other.idTokenExpirationPolicy;
        return !(this$idTokenExpirationPolicy == null ? other$idTokenExpirationPolicy != null : !this$idTokenExpirationPolicy.equals(other$idTokenExpirationPolicy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OidcRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.signIdToken ? 79 : 97);
        result = result * 59 + (this.encryptIdToken ? 79 : 97);
        long $clientSecretExpiration = this.clientSecretExpiration;
        result = result * 59 + (int)($clientSecretExpiration >>> 32 ^ $clientSecretExpiration);
        String $jwks = this.jwks;
        result = result * 59 + ($jwks == null ? 43 : $jwks.hashCode());
        String $jwksKeyId = this.jwksKeyId;
        result = result * 59 + ($jwksKeyId == null ? 43 : $jwksKeyId.hashCode());
        String $jwksCacheDuration = this.jwksCacheDuration;
        result = result * 59 + ($jwksCacheDuration == null ? 43 : $jwksCacheDuration.hashCode());
        String $tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        result = result * 59 + ($tokenEndpointAuthenticationMethod == null ? 43 : $tokenEndpointAuthenticationMethod.hashCode());
        String $idTokenEncryptionAlg = this.idTokenEncryptionAlg;
        result = result * 59 + ($idTokenEncryptionAlg == null ? 43 : $idTokenEncryptionAlg.hashCode());
        String $idTokenSigningAlg = this.idTokenSigningAlg;
        result = result * 59 + ($idTokenSigningAlg == null ? 43 : $idTokenSigningAlg.hashCode());
        String $userInfoSigningAlg = this.userInfoSigningAlg;
        result = result * 59 + ($userInfoSigningAlg == null ? 43 : $userInfoSigningAlg.hashCode());
        String $userInfoEncryptedResponseAlg = this.userInfoEncryptedResponseAlg;
        result = result * 59 + ($userInfoEncryptedResponseAlg == null ? 43 : $userInfoEncryptedResponseAlg.hashCode());
        String $userInfoEncryptedResponseEncoding = this.userInfoEncryptedResponseEncoding;
        result = result * 59 + ($userInfoEncryptedResponseEncoding == null ? 43 : $userInfoEncryptedResponseEncoding.hashCode());
        String $idTokenEncryptionEncoding = this.idTokenEncryptionEncoding;
        result = result * 59 + ($idTokenEncryptionEncoding == null ? 43 : $idTokenEncryptionEncoding.hashCode());
        String $idTokenIssuer = this.idTokenIssuer;
        result = result * 59 + ($idTokenIssuer == null ? 43 : $idTokenIssuer.hashCode());
        String $sectorIdentifierUri = this.sectorIdentifierUri;
        result = result * 59 + ($sectorIdentifierUri == null ? 43 : $sectorIdentifierUri.hashCode());
        String $applicationType = this.applicationType;
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $subjectType = this.subjectType;
        result = result * 59 + ($subjectType == null ? 43 : $subjectType.hashCode());
        RegisteredServiceOidcIdTokenExpirationPolicy $idTokenExpirationPolicy = this.idTokenExpirationPolicy;
        result = result * 59 + ($idTokenExpirationPolicy == null ? 43 : $idTokenExpirationPolicy.hashCode());
        return result;
    }

    @Generated
    public OidcRegisteredService() {
    }
}

