/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.JsonServiceRegistry;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.replication.NoOpRegisteredServiceReplicationStrategy;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.DefaultRegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Tag(value="OIDC")
public class OidcRegisteredServiceTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "oidcRegisteredService.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final ClassPathResource RESOURCE = new ClassPathResource("services");
    private final ServiceRegistry dao;

    public OidcRegisteredServiceTests() throws Exception {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        this.dao = new JsonServiceRegistry((Resource)RESOURCE, WatcherService.noOp(), (ConfigurableApplicationContext)appCtx, (RegisteredServiceReplicationStrategy)new NoOpRegisteredServiceReplicationStrategy(), (RegisteredServiceResourceNamingStrategy)new DefaultRegisteredServiceResourceNamingStrategy(), new ArrayList());
    }

    @BeforeAll
    public static void prepTests() throws Exception {
        FileUtils.cleanDirectory((File)RESOURCE.getFile());
    }

    @Test
    public void checkSaveMethod() {
        OidcRegisteredService r = new OidcRegisteredService();
        r.setName("checkSaveMethod");
        r.setServiceId("testId");
        r.setJwks("file:/tmp/thekeystorehere.jwks");
        r.setSignIdToken(true);
        r.setBypassApprovalPrompt(true);
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        Assertions.assertTrue((boolean)(r2 instanceof OidcRegisteredService));
        this.dao.load();
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assertions.assertTrue((boolean)(r3 instanceof OidcRegisteredService));
        Assertions.assertEquals((Object)r, (Object)r2);
        Assertions.assertEquals((Object)r2, (Object)r3);
        Assertions.assertNotNull((Object)r.newInstance());
        Assertions.assertNotNull((Object)r.getFriendlyName());
    }

    @Test
    public void verifySerializeAOidcRegisteredServiceToJson() throws IOException {
        OidcRegisteredService serviceWritten = new OidcRegisteredService();
        serviceWritten.setName("verifySerializeAOidcRegisteredServiceToJson");
        serviceWritten.setServiceId("testId");
        serviceWritten.setJwks("file:/tmp/thekeystorehere.jwks");
        serviceWritten.setSignIdToken(true);
        serviceWritten.setBypassApprovalPrompt(true);
        serviceWritten.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PairwiseOidcRegisteredServiceUsernameAttributeProvider());
        MAPPER.writeValue(JSON_FILE, (Object)serviceWritten);
        OidcRegisteredService serviceRead = (OidcRegisteredService)MAPPER.readValue(JSON_FILE, OidcRegisteredService.class);
        Assertions.assertEquals((Object)serviceWritten, (Object)serviceRead);
    }
}

