/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.OidcPairwisePersistentIdGenerator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PairwiseOidcRegisteredServiceUsernameAttributeProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PairwiseOidcRegisteredServiceUsernameAttributeProvider.class);
    private static final long serialVersionUID = 469929103943101717L;
    private PersistentIdGenerator persistentIdGenerator = new OidcPairwisePersistentIdGenerator();

    public String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        if (registeredService == null || !OidcRegisteredService.class.isAssignableFrom(registeredService.getClass())) {
            LOGGER.warn("Service definition [{}] is undefined or it's not an OpenId Connect relying party", (Object)registeredService);
            return principal.getId();
        }
        OidcRegisteredService oidcSvc = (OidcRegisteredService)((Object)OidcRegisteredService.class.cast(registeredService));
        if (StringUtils.isBlank((CharSequence)oidcSvc.getSubjectType()) || StringUtils.equalsIgnoreCase((CharSequence)OidcSubjectTypes.PUBLIC.getType(), (CharSequence)oidcSvc.getSubjectType())) {
            LOGGER.warn("Service definition [{}] does not request a pairwise subject type", (Object)oidcSvc);
            return principal.getId();
        }
        String sectorIdentifier = PairwiseOidcRegisteredServiceUsernameAttributeProvider.getSectorIdentifier(oidcSvc);
        String id = this.persistentIdGenerator.generate(principal, sectorIdentifier);
        LOGGER.debug("Resolved username [{}] for pairwise access", (Object)id);
        return id;
    }

    private static String getSectorIdentifier(OidcRegisteredService client) {
        if (!StringUtils.isBlank((CharSequence)client.getSectorIdentifierUri())) {
            UriComponents uri = UriComponentsBuilder.fromUriString((String)client.getSectorIdentifierUri()).build();
            return uri.getHost();
        }
        UriComponents uri = UriComponentsBuilder.fromUriString((String)client.getServiceId()).build();
        return uri.getHost();
    }

    @Generated
    public PersistentIdGenerator getPersistentIdGenerator() {
        return this.persistentIdGenerator;
    }

    @Generated
    public PairwiseOidcRegisteredServiceUsernameAttributeProvider() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PairwiseOidcRegisteredServiceUsernameAttributeProvider)) {
            return false;
        }
        PairwiseOidcRegisteredServiceUsernameAttributeProvider other = (PairwiseOidcRegisteredServiceUsernameAttributeProvider)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentIdGenerator this$persistentIdGenerator = this.persistentIdGenerator;
        PersistentIdGenerator other$persistentIdGenerator = other.persistentIdGenerator;
        return !(this$persistentIdGenerator == null ? other$persistentIdGenerator != null : !this$persistentIdGenerator.equals(other$persistentIdGenerator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PairwiseOidcRegisteredServiceUsernameAttributeProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PersistentIdGenerator $persistentIdGenerator = this.persistentIdGenerator;
        result = result * 59 + ($persistentIdGenerator == null ? 43 : $persistentIdGenerator.hashCode());
        return result;
    }

    @Generated
    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }
}

