/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class PairwiseOidcRegisteredServiceUsernameAttributeProviderTests {
    @Test
    public void verifyNonCompatibleService() {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        String uid = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)RegisteredServiceTestUtils.getRegisteredService());
        Assertions.assertEquals((Object)"casuser", (Object)uid);
    }

    @Test
    public void verifyUndefinedOrPublicSubjectType() {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        OidcRegisteredService registeredService = new OidcRegisteredService();
        registeredService.setName("verifyUndefinedOrPublicSubjectType");
        registeredService.setServiceId("testId");
        registeredService.setClientId("clientid");
        registeredService.setClientSecret("something");
        registeredService.setSubjectType("");
        String uid = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)registeredService);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
        registeredService.setSubjectType(null);
        uid = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)registeredService);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
        registeredService.setSubjectType(OidcSubjectTypes.PUBLIC.getType());
        uid = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)registeredService);
        Assertions.assertEquals((Object)"casuser", (Object)uid);
    }

    @Test
    public void verifySubjectType() {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider provider = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        provider.setPersistentIdGenerator((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("cpaOl1pwGZ439!!"));
        OidcRegisteredService registeredService = new OidcRegisteredService();
        registeredService.setName("verifySubjectType");
        registeredService.setSectorIdentifierUri("https://sso.example.org/oidc");
        registeredService.setClientId("clientid");
        registeredService.setClientSecret("something");
        registeredService.setSubjectType(OidcSubjectTypes.PAIRWISE.getType());
        String uid = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)registeredService);
        Assertions.assertEquals((Object)"9IOlxFj2XgfhkNJieynbw+Pm+4E=", (Object)uid);
        registeredService.setSectorIdentifierUri(null);
        registeredService.setServiceId("https://sso.example.org/oidc");
        String uid1 = provider.resolveUsername(RegisteredServiceTestUtils.getPrincipal((String)"casuser"), (Service)RegisteredServiceTestUtils.getService(), (RegisteredService)registeredService);
        Assertions.assertEquals((Object)uid1, (Object)uid);
    }
}

