/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;

@Entity
@DiscriminatorValue(value="oidc")
public class OidcRegisteredService
extends OAuthRegisteredService {
    private static final long serialVersionUID = 1310899699465091444L;
    @Column
    private String jwks;
    @Column
    private long jwksCacheDuration;
    @Column
    private String jwksCacheTimeUnit;
    @Column(name="token_auth_method")
    private String tokenEndpointAuthenticationMethod = "client_secret_basic";
    @Column
    private boolean signIdToken = true;
    @Column
    private boolean encryptIdToken;
    @Column
    private String idTokenEncryptionAlg;
    @Column
    private String idTokenSigningAlg;
    @Column
    private String userInfoSigningAlg;
    @Column(name="userinfo_enc_alg")
    private String userInfoEncryptedResponseAlg;
    @Column(name="userinfo_enc_enc")
    private String userInfoEncryptedResponseEncoding;
    @Column
    private String idTokenEncryptionEncoding;
    @Column
    private String sectorIdentifierUri;
    @Column
    private String applicationType = "web";
    @Column
    private String subjectType = OidcSubjectTypes.PUBLIC.getType();
    @Column
    private boolean dynamicallyRegistered;
    @JsonIgnore
    @Column
    @Deprecated
    @Transient
    @org.springframework.data.annotation.Transient
    private transient boolean implicit;
    @Column(name="DYNAMIC_REG_TIME")
    private ZonedDateTime dynamicRegistrationDateTime;
    @Lob
    @Column(name="scopes", length=0x7FFFFFFF)
    private HashSet<String> scopes = new HashSet();

    public String getSubjectType() {
        if (StringUtils.isBlank((CharSequence)this.subjectType)) {
            return OidcSubjectTypes.PUBLIC.getType();
        }
        return this.subjectType;
    }

    public void setDynamicallyRegistered(boolean dynamicallyRegistered) {
        if (dynamicallyRegistered && !this.dynamicallyRegistered && this.dynamicRegistrationDateTime == null) {
            this.setDynamicRegistrationDateTime(ZonedDateTime.now(ZoneOffset.UTC));
        }
        this.dynamicallyRegistered = dynamicallyRegistered;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet();
        }
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.getScopes().clear();
        this.getScopes().addAll(scopes);
    }

    public void initialize() {
        super.initialize();
        if (this.scopes == null) {
            this.scopes = new HashSet();
        }
    }

    protected AbstractRegisteredService newInstance() {
        return new OidcRegisteredService();
    }

    @JsonIgnore
    public String getFriendlyName() {
        return "OpenID Connect Relying Party";
    }

    @Generated
    public String toString() {
        return "OidcRegisteredService(super=" + super.toString() + ", jwks=" + this.jwks + ", jwksCacheDuration=" + this.jwksCacheDuration + ", jwksCacheTimeUnit=" + this.jwksCacheTimeUnit + ", tokenEndpointAuthenticationMethod=" + this.tokenEndpointAuthenticationMethod + ", signIdToken=" + this.signIdToken + ", encryptIdToken=" + this.encryptIdToken + ", idTokenEncryptionAlg=" + this.idTokenEncryptionAlg + ", idTokenSigningAlg=" + this.idTokenSigningAlg + ", userInfoSigningAlg=" + this.userInfoSigningAlg + ", userInfoEncryptedResponseAlg=" + this.userInfoEncryptedResponseAlg + ", userInfoEncryptedResponseEncoding=" + this.userInfoEncryptedResponseEncoding + ", idTokenEncryptionEncoding=" + this.idTokenEncryptionEncoding + ", sectorIdentifierUri=" + this.sectorIdentifierUri + ", applicationType=" + this.applicationType + ", subjectType=" + this.subjectType + ", dynamicallyRegistered=" + this.dynamicallyRegistered + ", implicit=" + this.implicit + ", dynamicRegistrationDateTime=" + this.dynamicRegistrationDateTime + ", scopes=" + this.scopes + ")";
    }

    @Generated
    public String getJwks() {
        return this.jwks;
    }

    @Generated
    public long getJwksCacheDuration() {
        return this.jwksCacheDuration;
    }

    @Generated
    public String getJwksCacheTimeUnit() {
        return this.jwksCacheTimeUnit;
    }

    @Generated
    public String getTokenEndpointAuthenticationMethod() {
        return this.tokenEndpointAuthenticationMethod;
    }

    @Generated
    public boolean isSignIdToken() {
        return this.signIdToken;
    }

    @Generated
    public boolean isEncryptIdToken() {
        return this.encryptIdToken;
    }

    @Generated
    public String getIdTokenEncryptionAlg() {
        return this.idTokenEncryptionAlg;
    }

    @Generated
    public String getIdTokenSigningAlg() {
        return this.idTokenSigningAlg;
    }

    @Generated
    public String getUserInfoSigningAlg() {
        return this.userInfoSigningAlg;
    }

    @Generated
    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    @Generated
    public String getUserInfoEncryptedResponseEncoding() {
        return this.userInfoEncryptedResponseEncoding;
    }

    @Generated
    public String getIdTokenEncryptionEncoding() {
        return this.idTokenEncryptionEncoding;
    }

    @Generated
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public boolean isDynamicallyRegistered() {
        return this.dynamicallyRegistered;
    }

    @Deprecated
    @Generated
    public boolean isImplicit() {
        return this.implicit;
    }

    @Generated
    public ZonedDateTime getDynamicRegistrationDateTime() {
        return this.dynamicRegistrationDateTime;
    }

    @Generated
    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    @Generated
    public void setJwksCacheDuration(long jwksCacheDuration) {
        this.jwksCacheDuration = jwksCacheDuration;
    }

    @Generated
    public void setJwksCacheTimeUnit(String jwksCacheTimeUnit) {
        this.jwksCacheTimeUnit = jwksCacheTimeUnit;
    }

    @Generated
    public void setTokenEndpointAuthenticationMethod(String tokenEndpointAuthenticationMethod) {
        this.tokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
    }

    @Generated
    public void setSignIdToken(boolean signIdToken) {
        this.signIdToken = signIdToken;
    }

    @Generated
    public void setEncryptIdToken(boolean encryptIdToken) {
        this.encryptIdToken = encryptIdToken;
    }

    @Generated
    public void setIdTokenEncryptionAlg(String idTokenEncryptionAlg) {
        this.idTokenEncryptionAlg = idTokenEncryptionAlg;
    }

    @Generated
    public void setIdTokenSigningAlg(String idTokenSigningAlg) {
        this.idTokenSigningAlg = idTokenSigningAlg;
    }

    @Generated
    public void setUserInfoSigningAlg(String userInfoSigningAlg) {
        this.userInfoSigningAlg = userInfoSigningAlg;
    }

    @Generated
    public void setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    @Generated
    public void setUserInfoEncryptedResponseEncoding(String userInfoEncryptedResponseEncoding) {
        this.userInfoEncryptedResponseEncoding = userInfoEncryptedResponseEncoding;
    }

    @Generated
    public void setIdTokenEncryptionEncoding(String idTokenEncryptionEncoding) {
        this.idTokenEncryptionEncoding = idTokenEncryptionEncoding;
    }

    @Generated
    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    @Generated
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @Generated
    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    @Deprecated
    @Generated
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Generated
    public void setDynamicRegistrationDateTime(ZonedDateTime dynamicRegistrationDateTime) {
        this.dynamicRegistrationDateTime = dynamicRegistrationDateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcRegisteredService)) {
            return false;
        }
        OidcRegisteredService other = (OidcRegisteredService)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jwks = this.jwks;
        String other$jwks = other.jwks;
        if (this$jwks == null ? other$jwks != null : !this$jwks.equals(other$jwks)) {
            return false;
        }
        if (this.jwksCacheDuration != other.jwksCacheDuration) {
            return false;
        }
        String this$jwksCacheTimeUnit = this.jwksCacheTimeUnit;
        String other$jwksCacheTimeUnit = other.jwksCacheTimeUnit;
        if (this$jwksCacheTimeUnit == null ? other$jwksCacheTimeUnit != null : !this$jwksCacheTimeUnit.equals(other$jwksCacheTimeUnit)) {
            return false;
        }
        String this$tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        String other$tokenEndpointAuthenticationMethod = other.tokenEndpointAuthenticationMethod;
        if (this$tokenEndpointAuthenticationMethod == null ? other$tokenEndpointAuthenticationMethod != null : !this$tokenEndpointAuthenticationMethod.equals(other$tokenEndpointAuthenticationMethod)) {
            return false;
        }
        if (this.signIdToken != other.signIdToken) {
            return false;
        }
        if (this.encryptIdToken != other.encryptIdToken) {
            return false;
        }
        String this$idTokenEncryptionAlg = this.idTokenEncryptionAlg;
        String other$idTokenEncryptionAlg = other.idTokenEncryptionAlg;
        if (this$idTokenEncryptionAlg == null ? other$idTokenEncryptionAlg != null : !this$idTokenEncryptionAlg.equals(other$idTokenEncryptionAlg)) {
            return false;
        }
        String this$idTokenSigningAlg = this.idTokenSigningAlg;
        String other$idTokenSigningAlg = other.idTokenSigningAlg;
        if (this$idTokenSigningAlg == null ? other$idTokenSigningAlg != null : !this$idTokenSigningAlg.equals(other$idTokenSigningAlg)) {
            return false;
        }
        String this$userInfoSigningAlg = this.userInfoSigningAlg;
        String other$userInfoSigningAlg = other.userInfoSigningAlg;
        if (this$userInfoSigningAlg == null ? other$userInfoSigningAlg != null : !this$userInfoSigningAlg.equals(other$userInfoSigningAlg)) {
            return false;
        }
        String this$userInfoEncryptedResponseAlg = this.userInfoEncryptedResponseAlg;
        String other$userInfoEncryptedResponseAlg = other.userInfoEncryptedResponseAlg;
        if (this$userInfoEncryptedResponseAlg == null ? other$userInfoEncryptedResponseAlg != null : !this$userInfoEncryptedResponseAlg.equals(other$userInfoEncryptedResponseAlg)) {
            return false;
        }
        String this$userInfoEncryptedResponseEncoding = this.userInfoEncryptedResponseEncoding;
        String other$userInfoEncryptedResponseEncoding = other.userInfoEncryptedResponseEncoding;
        if (this$userInfoEncryptedResponseEncoding == null ? other$userInfoEncryptedResponseEncoding != null : !this$userInfoEncryptedResponseEncoding.equals(other$userInfoEncryptedResponseEncoding)) {
            return false;
        }
        String this$idTokenEncryptionEncoding = this.idTokenEncryptionEncoding;
        String other$idTokenEncryptionEncoding = other.idTokenEncryptionEncoding;
        if (this$idTokenEncryptionEncoding == null ? other$idTokenEncryptionEncoding != null : !this$idTokenEncryptionEncoding.equals(other$idTokenEncryptionEncoding)) {
            return false;
        }
        String this$sectorIdentifierUri = this.sectorIdentifierUri;
        String other$sectorIdentifierUri = other.sectorIdentifierUri;
        if (this$sectorIdentifierUri == null ? other$sectorIdentifierUri != null : !this$sectorIdentifierUri.equals(other$sectorIdentifierUri)) {
            return false;
        }
        String this$applicationType = this.applicationType;
        String other$applicationType = other.applicationType;
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$subjectType = this.subjectType;
        String other$subjectType = other.subjectType;
        if (this$subjectType == null ? other$subjectType != null : !this$subjectType.equals(other$subjectType)) {
            return false;
        }
        if (this.dynamicallyRegistered != other.dynamicallyRegistered) {
            return false;
        }
        ZonedDateTime this$dynamicRegistrationDateTime = this.dynamicRegistrationDateTime;
        ZonedDateTime other$dynamicRegistrationDateTime = other.dynamicRegistrationDateTime;
        if (this$dynamicRegistrationDateTime == null ? other$dynamicRegistrationDateTime != null : !((Object)this$dynamicRegistrationDateTime).equals(other$dynamicRegistrationDateTime)) {
            return false;
        }
        HashSet<String> this$scopes = this.scopes;
        HashSet<String> other$scopes = other.scopes;
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OidcRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jwks = this.jwks;
        result = result * 59 + ($jwks == null ? 43 : $jwks.hashCode());
        long $jwksCacheDuration = this.jwksCacheDuration;
        result = result * 59 + (int)($jwksCacheDuration >>> 32 ^ $jwksCacheDuration);
        String $jwksCacheTimeUnit = this.jwksCacheTimeUnit;
        result = result * 59 + ($jwksCacheTimeUnit == null ? 43 : $jwksCacheTimeUnit.hashCode());
        String $tokenEndpointAuthenticationMethod = this.tokenEndpointAuthenticationMethod;
        result = result * 59 + ($tokenEndpointAuthenticationMethod == null ? 43 : $tokenEndpointAuthenticationMethod.hashCode());
        result = result * 59 + (this.signIdToken ? 79 : 97);
        result = result * 59 + (this.encryptIdToken ? 79 : 97);
        String $idTokenEncryptionAlg = this.idTokenEncryptionAlg;
        result = result * 59 + ($idTokenEncryptionAlg == null ? 43 : $idTokenEncryptionAlg.hashCode());
        String $idTokenSigningAlg = this.idTokenSigningAlg;
        result = result * 59 + ($idTokenSigningAlg == null ? 43 : $idTokenSigningAlg.hashCode());
        String $userInfoSigningAlg = this.userInfoSigningAlg;
        result = result * 59 + ($userInfoSigningAlg == null ? 43 : $userInfoSigningAlg.hashCode());
        String $userInfoEncryptedResponseAlg = this.userInfoEncryptedResponseAlg;
        result = result * 59 + ($userInfoEncryptedResponseAlg == null ? 43 : $userInfoEncryptedResponseAlg.hashCode());
        String $userInfoEncryptedResponseEncoding = this.userInfoEncryptedResponseEncoding;
        result = result * 59 + ($userInfoEncryptedResponseEncoding == null ? 43 : $userInfoEncryptedResponseEncoding.hashCode());
        String $idTokenEncryptionEncoding = this.idTokenEncryptionEncoding;
        result = result * 59 + ($idTokenEncryptionEncoding == null ? 43 : $idTokenEncryptionEncoding.hashCode());
        String $sectorIdentifierUri = this.sectorIdentifierUri;
        result = result * 59 + ($sectorIdentifierUri == null ? 43 : $sectorIdentifierUri.hashCode());
        String $applicationType = this.applicationType;
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $subjectType = this.subjectType;
        result = result * 59 + ($subjectType == null ? 43 : $subjectType.hashCode());
        result = result * 59 + (this.dynamicallyRegistered ? 79 : 97);
        ZonedDateTime $dynamicRegistrationDateTime = this.dynamicRegistrationDateTime;
        result = result * 59 + ($dynamicRegistrationDateTime == null ? 43 : ((Object)$dynamicRegistrationDateTime).hashCode());
        HashSet<String> $scopes = this.scopes;
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    @Generated
    public OidcRegisteredService() {
    }
}

