/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.JsonServiceRegistryDao;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ServiceRegistryDao;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class OidcRegisteredServiceTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "oidcRegisteredService.json");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ClassPathResource RESOURCE = new ClassPathResource("services");
    private final ServiceRegistryDao dao = new JsonServiceRegistryDao((Resource)RESOURCE, false, (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class));

    @BeforeClass
    public static void prepTests() throws Exception {
        FileUtils.cleanDirectory((File)RESOURCE.getFile());
    }

    @Test
    public void checkSaveMethod() {
        OidcRegisteredService r = new OidcRegisteredService();
        r.setName("checkSaveMethod");
        r.setServiceId("testId");
        r.setJwks("file:/etc/cas/thekeystorehere.jwks");
        r.setSignIdToken(true);
        r.setBypassApprovalPrompt(Boolean.valueOf(true));
        RegisteredService r2 = this.dao.save((RegisteredService)r);
        Assert.assertTrue((boolean)(r2 instanceof OidcRegisteredService));
        this.dao.load();
        RegisteredService r3 = this.dao.findServiceById(r2.getId());
        Assert.assertTrue((boolean)(r3 instanceof OidcRegisteredService));
        Assert.assertEquals((Object)r, (Object)r2);
        Assert.assertEquals((Object)r2, (Object)r3);
    }

    @Test
    public void verifySerializeAOidcRegisteredServiceToJson() throws IOException {
        OidcRegisteredService serviceWritten = new OidcRegisteredService();
        serviceWritten.setName("verifySerializeAOidcRegisteredServiceToJson");
        serviceWritten.setServiceId("testId");
        serviceWritten.setJwks("file:/etc/cas/thekeystorehere.jwks");
        serviceWritten.setSignIdToken(true);
        serviceWritten.setBypassApprovalPrompt(Boolean.valueOf(true));
        serviceWritten.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PairwiseOidcRegisteredServiceUsernameAttributeProvider());
        MAPPER.writeValue(JSON_FILE, (Object)serviceWritten);
        RegisteredService serviceRead = (RegisteredService)MAPPER.readValue(JSON_FILE, OidcRegisteredService.class);
        Assert.assertEquals((Object)serviceWritten, (Object)serviceRead);
    }
}

