/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.OidcPairwisePersistentIdGenerator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PairwiseOidcRegisteredServiceUsernameAttributeProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = 469929103943101717L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PairwiseOidcRegisteredServiceUsernameAttributeProvider.class);
    private PersistentIdGenerator persistentIdGenerator = new OidcPairwisePersistentIdGenerator();

    public String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        if (registeredService == null || !OidcRegisteredService.class.isAssignableFrom(registeredService.getClass())) {
            LOGGER.warn("Service definition [{}] is undefined or it's not an OpenId Connect relying party", (Object)registeredService);
            return principal.getId();
        }
        OidcRegisteredService oidcSvc = (OidcRegisteredService)((Object)OidcRegisteredService.class.cast(registeredService));
        if (StringUtils.isBlank((CharSequence)oidcSvc.getSubjectType()) || StringUtils.equalsIgnoreCase((CharSequence)OidcSubjectTypes.PUBLIC.getType(), (CharSequence)oidcSvc.getSubjectType())) {
            LOGGER.warn("Service definition [{}] does not request a pairwise subject type", (Object)oidcSvc);
            return principal.getId();
        }
        String sectorIdentifier = this.getSectorIdentifier(oidcSvc);
        if (StringUtils.isBlank((CharSequence)sectorIdentifier)) {
            LOGGER.debug("Service definition [{}] does not provide a sector identifier", (Object)oidcSvc);
            return principal.getId();
        }
        if (this.persistentIdGenerator == null) {
            throw new IllegalArgumentException("No pairwise persistent id generator is defined");
        }
        String id = this.persistentIdGenerator.generate(principal, (Service)new PairwiseService(sectorIdentifier));
        LOGGER.debug("Resolved username [{}] for pairwise access", (Object)id);
        return id;
    }

    private String getSectorIdentifier(OidcRegisteredService client) {
        if (!StringUtils.isBlank((CharSequence)client.getSectorIdentifierUri())) {
            UriComponents uri = UriComponentsBuilder.fromUriString((String)client.getSectorIdentifierUri()).build();
            return uri.getHost();
        }
        UriComponents uri = UriComponentsBuilder.fromUriString((String)client.getServiceId()).build();
        return uri.getHost();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        PairwiseOidcRegisteredServiceUsernameAttributeProvider rhs = (PairwiseOidcRegisteredServiceUsernameAttributeProvider)((Object)obj);
        EqualsBuilder builder = new EqualsBuilder();
        return builder.appendSuper(super.equals(obj)).append((Object)this.persistentIdGenerator, (Object)rhs.persistentIdGenerator).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.persistentIdGenerator).toHashCode();
    }

    private static class PairwiseService
    implements Service {
        private static final long serialVersionUID = -6154643329901712381L;
        private final String id;

        PairwiseService(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

