/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.google.common.base.Throwables;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;

@Entity
@DiscriminatorValue(value="oidc")
public class OidcRegisteredService
extends OAuthRegisteredService {
    private static final long serialVersionUID = 1310899699465091444L;
    @Column(length=255, updatable=true, insertable=true)
    private String jwks;
    @Column(updatable=true, insertable=true)
    private boolean signIdToken = true;
    @Column(updatable=true, insertable=true)
    private boolean encryptIdToken;
    @Column(length=255, updatable=true, insertable=true)
    private String idTokenEncryptionAlg;
    @Column(length=255, updatable=true, insertable=true)
    private String idTokenEncryptionEncoding;
    @Column(updatable=true, insertable=true)
    private boolean dynamicallyRegistered;
    @Column(updatable=true, insertable=true)
    private boolean implicit;
    @Column(name="DYNAMIC_REG_TIME")
    private ZonedDateTime dynamicRegistrationDateTime;
    @Lob
    @Column(name="scopes", length=0x7FFFFFFF)
    private HashSet<String> scopes = new HashSet();

    public OidcRegisteredService() {
        this.setJsonFormat(Boolean.TRUE);
    }

    public boolean isEncryptIdToken() {
        return this.encryptIdToken;
    }

    public void setEncryptIdToken(boolean encryptIdToken) {
        this.encryptIdToken = encryptIdToken;
    }

    public boolean isSignIdToken() {
        return this.signIdToken;
    }

    public void setSignIdToken(boolean signIdToken) {
        this.signIdToken = signIdToken;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public String getIdTokenEncryptionAlg() {
        return this.idTokenEncryptionAlg;
    }

    public void setIdTokenEncryptionAlg(String idTokenEncryptionAlg) {
        this.idTokenEncryptionAlg = idTokenEncryptionAlg;
    }

    public String getIdTokenEncryptionEncoding() {
        return this.idTokenEncryptionEncoding;
    }

    public void setIdTokenEncryptionEncoding(String idTokenEncryptionEncoding) {
        this.idTokenEncryptionEncoding = idTokenEncryptionEncoding;
    }

    public boolean isDynamicallyRegistered() {
        return this.dynamicallyRegistered;
    }

    public void setDynamicallyRegistered(boolean dynamicallyRegistered) {
        if (dynamicallyRegistered && !this.dynamicallyRegistered && this.dynamicRegistrationDateTime == null) {
            this.setDynamicRegistrationDateTime(ZonedDateTime.now());
        }
        this.dynamicallyRegistered = dynamicallyRegistered;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet();
        }
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.getScopes().clear();
        this.getScopes().addAll(scopes);
    }

    public ZonedDateTime getDynamicRegistrationDateTime() {
        return this.dynamicRegistrationDateTime;
    }

    public void setDynamicRegistrationDateTime(ZonedDateTime dynamicRegistrationDateTime) {
        this.dynamicRegistrationDateTime = dynamicRegistrationDateTime;
    }

    @PostLoad
    public void postLoad() {
        if (this.scopes == null) {
            this.scopes = new HashSet();
        }
    }

    protected AbstractRegisteredService newInstance() {
        return new OidcRegisteredService();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OidcRegisteredService rhs = (OidcRegisteredService)((Object)obj);
        EqualsBuilder builder = new EqualsBuilder();
        return builder.appendSuper(super.equals(obj)).append((Object)this.jwks, (Object)rhs.jwks).append(this.implicit, rhs.implicit).append(this.signIdToken, rhs.signIdToken).append(this.encryptIdToken, rhs.encryptIdToken).append((Object)this.idTokenEncryptionAlg, (Object)rhs.idTokenEncryptionAlg).append((Object)this.idTokenEncryptionEncoding, (Object)rhs.idTokenEncryptionEncoding).append(this.getScopes(), rhs.getScopes()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.jwks).append(this.signIdToken).append(this.implicit).append(this.encryptIdToken).append((Object)this.idTokenEncryptionAlg).append((Object)this.idTokenEncryptionEncoding).append(this.dynamicallyRegistered).append(this.getScopes()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("jwks", (Object)this.jwks).append("implicit", this.implicit).append("signIdToken", this.signIdToken).append("idTokenEncryptionAlg", (Object)this.idTokenEncryptionAlg).append("idTokenEncryptionEncoding", (Object)this.idTokenEncryptionEncoding).append("encryptIdToken", this.encryptIdToken).append("dynamicallyRegistered", this.dynamicallyRegistered).append("scopes", this.getScopes()).toString();
    }

    public void copyFrom(RegisteredService source) {
        super.copyFrom(source);
        try {
            OidcRegisteredService oidcService = (OidcRegisteredService)source;
            this.setJwks(oidcService.getJwks());
            this.setImplicit(oidcService.isImplicit());
            this.setSignIdToken(oidcService.isSignIdToken());
            this.setIdTokenEncryptionAlg(oidcService.getIdTokenEncryptionAlg());
            this.setIdTokenEncryptionEncoding(oidcService.idTokenEncryptionEncoding);
            this.setEncryptIdToken(oidcService.isEncryptIdToken());
            this.setDynamicallyRegistered(oidcService.isDynamicallyRegistered());
            this.setScopes(oidcService.getScopes());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

