/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@ContextConfiguration(locations={"classpath:/jpaTestApplicationContext.xml"})
public class SearchModeSearchDatabaseAuthenticationHandlerTests {
    private SearchModeSearchDatabaseAuthenticationHandler handler;
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Before
    public void setUp() throws Exception {
        this.handler = new SearchModeSearchDatabaseAuthenticationHandler();
        this.handler.setDataSource(this.dataSource);
        this.handler.setTableUsers("cassearchusers");
        this.handler.setFieldUser("username");
        this.handler.setFieldPassword("password");
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        s.execute(SearchModeSearchDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(0));
        for (int i = 0; i < 10; ++i) {
            s.execute(SearchModeSearchDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(i));
        }
        c.close();
    }

    @After
    public void tearDown() throws Exception {
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        for (int i = 0; i < 5; ++i) {
            String sql = String.format("delete from casusers;", new Object[0]);
            s.execute(sql);
        }
        c.close();
    }

    private static String getSqlInsertStatementToCreateUserAccount(int i) {
        return String.format("insert into cassearchusers (username, password) values('%s', '%s');", "user" + i, "psw" + i);
    }

    @Test(expected=FailedLoginException.class)
    public void verifyNotFoundUser() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"hello", (String)"world");
        this.handler.authenticateUsernamePasswordInternal(c);
    }

    @Test
    public void verifyFoundUser() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user3", (String)"psw3");
        Assert.assertNotNull((Object)this.handler.authenticateUsernamePasswordInternal(c));
    }

    @Test
    public void verifyMultipleUsersFound() throws Exception {
        UsernamePasswordCredential c = TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user0", (String)"psw0");
        Assert.assertNotNull((Object)this.handler.authenticateUsernamePasswordInternal(c));
    }

    @Entity(name="cassearchusers")
    public static class UsersTable {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        private Long id;
        private String username;
        private String password;
    }
}

