/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@ContextConfiguration(locations={"classpath:/jpaTestApplicationContext.xml"})
public class QueryDatabaseAuthenticationHandlerTests {
    private static final String SQL = "SELECT password FROM casusers where username=?";
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Before
    public void setUp() throws Exception {
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        s.execute(QueryDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(0));
        for (int i = 0; i < 10; ++i) {
            s.execute(QueryDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(i));
        }
        c.close();
    }

    @After
    public void tearDown() throws Exception {
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        for (int i = 0; i < 5; ++i) {
            String sql = String.format("delete from casusers;", new Object[0]);
            s.execute(sql);
        }
        c.close();
    }

    private static String getSqlInsertStatementToCreateUserAccount(int i) {
        return String.format("insert into casusers (username, password) values('%s', '%s');", "user" + i, "psw" + i);
    }

    @Test(expected=AccountNotFoundException.class)
    public void verifyAuthenticationFailsToFindUser() throws Exception {
        QueryDatabaseAuthenticationHandler q = new QueryDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setSql(SQL);
        q.authenticateUsernamePasswordInternal(TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"usernotfound", (String)"psw1"));
    }

    @Test(expected=FailedLoginException.class)
    public void verifyPasswordInvalid() throws Exception {
        QueryDatabaseAuthenticationHandler q = new QueryDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setSql(SQL);
        q.authenticateUsernamePasswordInternal(TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user1", (String)"psw11"));
    }

    @Test(expected=FailedLoginException.class)
    public void verifyMultipleRecords() throws Exception {
        QueryDatabaseAuthenticationHandler q = new QueryDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setSql(SQL);
        q.authenticateUsernamePasswordInternal(TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user0", (String)"psw0"));
    }

    @Test(expected=PreventedException.class)
    public void verifyBadQuery() throws Exception {
        QueryDatabaseAuthenticationHandler q = new QueryDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setSql(SQL.replace("password", "*"));
        q.authenticateUsernamePasswordInternal(TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user0", (String)"psw0"));
    }

    public void verifySuccess() throws Exception {
        QueryDatabaseAuthenticationHandler q = new QueryDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setSql(SQL);
        Assert.assertNotNull((Object)q.authenticateUsernamePasswordInternal(TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user3", (String)"psw3")));
    }

    @Entity(name="casusers")
    public static class UsersTable {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        private Long id;
        private String username;
        private String password;
    }
}

