/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.Statement;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.configuration.support.PrefixSuffixPrincipalNameTransformer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@ContextConfiguration(locations={"classpath:/jpaTestApplicationContext.xml"})
public class QueryAndEncodeDatabaseAuthenticationHandlerTests {
    private static final String ALG_NAME = "SHA-512";
    private static final String SQL = "SELECT * FROM users where %s";
    private static final int NUM_ITERATIONS = 5;
    private static final String STATIC_SALT = "STATIC_SALT";
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Before
    public void setUp() throws Exception {
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        s.execute(QueryAndEncodeDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(0));
        for (int i = 0; i < 10; ++i) {
            s.execute(QueryAndEncodeDatabaseAuthenticationHandlerTests.getSqlInsertStatementToCreateUserAccount(i));
        }
        c.close();
    }

    private static String getSqlInsertStatementToCreateUserAccount(int i) {
        String psw = QueryAndEncodeDatabaseAuthenticationHandlerTests.genPassword("user" + i, "salt" + i, 5);
        String sql = String.format("insert into users (username, password, salt, numIterations) values('%s', '%s', '%s', %s);", "user" + i, psw, "salt" + i, 5);
        return sql;
    }

    @After
    public void tearDown() throws Exception {
        Connection c = this.dataSource.getConnection();
        Statement s = c.createStatement();
        c.setAutoCommit(true);
        for (int i = 0; i < 5; ++i) {
            String sql = String.format("delete from users;", new Object[0]);
            s.execute(sql);
        }
        c.close();
    }

    @Test(expected=AccountNotFoundException.class)
    public void verifyAuthenticationFailsToFindUser() throws Exception {
        QueryAndEncodeDatabaseAuthenticationHandler q = new QueryAndEncodeDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setAlgorithmName(ALG_NAME);
        q.setSql(QueryAndEncodeDatabaseAuthenticationHandlerTests.buildSql());
        q.authenticate((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword());
    }

    @Test(expected=PreventedException.class)
    public void verifyAuthenticationInvalidSql() throws Exception {
        QueryAndEncodeDatabaseAuthenticationHandler q = new QueryAndEncodeDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setAlgorithmName(ALG_NAME);
        q.setSql(QueryAndEncodeDatabaseAuthenticationHandlerTests.buildSql("makesNoSenseInSql"));
        q.authenticate((Credential)TestUtils.getCredentialsWithSameUsernameAndPassword());
    }

    @Test(expected=FailedLoginException.class)
    public void verifyAuthenticationMultipleAccounts() throws Exception {
        QueryAndEncodeDatabaseAuthenticationHandler q = new QueryAndEncodeDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setAlgorithmName(ALG_NAME);
        q.setSql(QueryAndEncodeDatabaseAuthenticationHandlerTests.buildSql());
        q.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"user0", (String)"password0"));
    }

    @Test
    public void verifyAuthenticationSuccessful() throws Exception {
        QueryAndEncodeDatabaseAuthenticationHandler q = new QueryAndEncodeDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setAlgorithmName(ALG_NAME);
        q.setSql(QueryAndEncodeDatabaseAuthenticationHandlerTests.buildSql());
        q.setNumberOfIterationsFieldName("numIterations");
        q.setStaticSalt(STATIC_SALT);
        q.setSaltFieldName("salt");
        UsernamePasswordCredential c = TestUtils.getCredentialsWithSameUsernameAndPassword((String)"user1");
        HandlerResult r = q.authenticate((Credential)c);
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)r.getPrincipal().getId(), (Object)"user1");
    }

    @Test
    public void verifyAuthenticationSuccessfulWithAPasswordEncoder() throws Exception {
        QueryAndEncodeDatabaseAuthenticationHandler q = new QueryAndEncodeDatabaseAuthenticationHandler();
        q.setDataSource(this.dataSource);
        q.setAlgorithmName(ALG_NAME);
        q.setSql(QueryAndEncodeDatabaseAuthenticationHandlerTests.buildSql());
        q.setNumberOfIterationsFieldName("numIterations");
        q.setStaticSalt(STATIC_SALT);
        q.setSaltFieldName("salt");
        q.setPasswordFieldName("password");
        q.setPasswordEncoder(new PasswordEncoder(){

            public String encode(CharSequence password) {
                return password.toString().concat("1");
            }

            public boolean matches(CharSequence rawPassword, String encodedPassword) {
                return true;
            }
        });
        q.setPrincipalNameTransformer((PrincipalNameTransformer)new PrefixSuffixPrincipalNameTransformer("user", null));
        HandlerResult r = q.authenticate((Credential)TestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"1", (String)"user"));
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)r.getPrincipal().getId(), (Object)"user1");
    }

    private static String buildSql(String where) {
        return String.format(SQL, where);
    }

    private static String buildSql() {
        return String.format(SQL, "username=?;");
    }

    private static String genPassword(String psw, String salt, int iter) {
        try {
            DefaultHashService hash = new DefaultHashService();
            hash.setPrivateSalt(ByteSource.Util.bytes((String)STATIC_SALT));
            hash.setHashIterations(iter);
            hash.setGeneratePublicSalt(false);
            hash.setHashAlgorithmName(ALG_NAME);
            String pswEnc = hash.computeHash(new HashRequest.Builder().setSource((Object)psw).setSalt((Object)salt).setIterations(iter).build()).toHex();
            return pswEnc;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Entity(name="users")
    public static class UsersTable {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        private Long id;
        private String username;
        private String password;
        private String salt;
        private long numIterations;
    }
}

