/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicates;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.apereo.cas.ticket.registry.HazelcastTicketDocument;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Monitorable
public class HazelcastTicketRegistry
extends AbstractTicketRegistry
implements AutoCloseable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistry.class);
    private final HazelcastInstance hazelcastInstance;
    private final HazelcastTicketRegistryProperties properties;

    public HazelcastTicketRegistry(CipherExecutor cipherExecutor, TicketSerializationManager ticketSerializationManager, TicketCatalog ticketCatalog, HazelcastInstance hazelcastInstance, HazelcastTicketRegistryProperties properties) {
        super(cipherExecutor, ticketSerializationManager, ticketCatalog);
        this.hazelcastInstance = hazelcastInstance;
        this.properties = properties;
    }

    public Ticket updateTicket(Ticket ticket) throws Exception {
        this.addTicket(ticket);
        return ticket;
    }

    public Ticket addSingleTicket(Ticket ticket) throws Exception {
        Long ttl = ticket.getExpirationPolicy().getTimeToLive();
        if (ttl < 0L || ttl >= Integer.MAX_VALUE) {
            LOGGER.debug("The expiration policy of ticket [{}] is set to use a negative (i.e. infinite) ttl", (Object)ticket.getId());
            ttl = 0L;
        }
        LOGGER.debug("Adding ticket [{}] with ttl [{}s]", (Object)ticket.getId(), (Object)ttl);
        Ticket encTicket = this.encodeTicket(ticket);
        TicketDefinition metadata = this.ticketCatalog.find(ticket);
        IMap<String, HazelcastTicketDocument> ticketMap = this.getTicketMapInstanceByMetadata(metadata);
        if (ticketMap != null) {
            ServiceAwareTicket sat;
            Object holder = ((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)((HazelcastTicketDocument.HazelcastTicketDocumentBuilder)HazelcastTicketDocument.builder().id(encTicket.getId())).type(metadata.getImplementationClass().getName())).principal(this.digestIdentifier(HazelcastTicketRegistry.getPrincipalIdFrom((Ticket)ticket)))).timeToLive(ttl)).ticket(encTicket)).prefix(metadata.getPrefix())).service(ticket instanceof ServiceAwareTicket && Objects.nonNull((sat = (ServiceAwareTicket)ticket).getService()) ? sat.getService().getId() : null)).attributes(this.collectAndDigestTicketAttributes(ticket))).build();
            ticketMap.set((Object)encTicket.getId(), holder, ttl.longValue(), TimeUnit.SECONDS);
            LOGGER.debug("Added ticket [{}] with ttl [{}s]", (Object)encTicket.getId(), (Object)ttl);
        } else {
            LOGGER.warn("Unable to locate ticket map for ticket metadata [{}]", (Object)metadata);
        }
        return ticket;
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        String encTicketId = this.digestIdentifier(ticketId);
        if (StringUtils.isBlank((CharSequence)encTicketId)) {
            return null;
        }
        TicketDefinition metadata = this.ticketCatalog.find(ticketId);
        if (metadata != null) {
            IMap<String, HazelcastTicketDocument> map = this.getTicketMapInstanceByMetadata(metadata);
            if (map != null) {
                HazelcastTicketDocument ticketHolder = (HazelcastTicketDocument)map.get((Object)encTicketId);
                if (ticketHolder != null && ticketHolder.getTicket() != null) {
                    Ticket result = this.decodeTicket(ticketHolder.getTicket());
                    if (predicate != null && predicate.test(result)) {
                        return result;
                    }
                }
                return null;
            }
            LOGGER.error("Unable to locate ticket map for ticket definition [{}]", (Object)metadata);
        }
        LOGGER.warn("No ticket definition could be found in the catalog to match [{}]", (Object)ticketId);
        return null;
    }

    public long deleteSingleTicket(Ticket ticketToDelete) {
        String encTicketId = this.digestIdentifier(ticketToDelete.getId());
        TicketDefinition metadata = this.ticketCatalog.find(ticketToDelete);
        IMap<String, HazelcastTicketDocument> map = this.getTicketMapInstanceByMetadata(metadata);
        return map != null && map.remove((Object)encTicketId) != null ? 1L : 0L;
    }

    public long deleteAll() {
        return this.ticketCatalog.findAll().stream().map(this::getTicketMapInstanceByMetadata).filter(Objects::nonNull).mapToInt(instance -> {
            int size = instance.size();
            instance.evictAll();
            instance.clear();
            return size;
        }).sum();
    }

    public Collection<? extends Ticket> getTickets() {
        return this.ticketCatalog.findAll().stream().map(metadata -> this.getTicketMapInstanceByMetadata((TicketDefinition)metadata).values()).flatMap(tickets -> {
            if (this.properties.getPageSize() > 0L) {
                return tickets.stream().limit(this.properties.getPageSize()).map(HazelcastTicketDocument::getTicket).toList().stream();
            }
            return tickets.stream().map(HazelcastTicketDocument::getTicket);
        }).map(arg_0 -> ((HazelcastTicketRegistry)this).decodeTicket(arg_0)).collect(Collectors.toSet());
    }

    public long countSessionsFor(String principalId) {
        if (this.properties.getCore().isEnableJet()) {
            TicketDefinition md = this.ticketCatalog.find("TGT");
            String sql = String.format("SELECT COUNT(*) FROM %s WHERE principal=?", md.getProperties().getStorageName());
            LOGGER.debug("Executing SQL query [{}]", (Object)sql);
            try (SqlResult results = this.hazelcastInstance.getSql().execute(sql, new Object[]{this.digestIdentifier(principalId)});){
                long l = (Long)((SqlRow)results.iterator().next()).getObject(0);
                return l;
            }
        }
        return super.countSessionsFor(principalId);
    }

    public long countTicketsFor(Service service) {
        if (this.properties.getCore().isEnableJet()) {
            return this.ticketCatalog.findAll().stream().mapToLong(ticketDefinition -> {
                String sql = String.format("SELECT COUNT(*) FROM %s WHERE service=?", ticketDefinition.getProperties().getStorageName());
                LOGGER.debug("Executing SQL query [{}]", (Object)sql);
                try (SqlResult results = this.hazelcastInstance.getSql().execute(sql, new Object[]{service.getId()});){
                    long l = (Long)((SqlRow)results.iterator().next()).getObject(0);
                    return l;
                }
            }).sum();
        }
        return super.countTicketsFor(service);
    }

    public Stream<? extends Ticket> getSessionsWithAttributes(Map<String, List<Object>> queryAttributes) {
        if (this.properties.getCore().isEnableJet()) {
            TicketDefinition md = this.ticketCatalog.find("TGT");
            IMap<String, HazelcastTicketDocument> ticketMapInstance = this.getTicketMapInstance(md.getProperties().getStorageName());
            ArrayList queryBuilder = new ArrayList();
            queryAttributes.forEach((key, values) -> {
                String valuesAsString = values.stream().map(Object::toString).map(arg_0 -> ((HazelcastTicketRegistry)this).digestIdentifier(arg_0)).map(singleValue -> String.format("'%s'", singleValue)).collect(Collectors.joining(","));
                String query = String.format("attributes[%s] IN (%s)", this.digestIdentifier((String)key), valuesAsString);
                queryBuilder.add(query);
            });
            String query = "(" + String.join((CharSequence)" OR ", queryBuilder) + ") AND " + String.format("prefix='%s'", md.getPrefix());
            LOGGER.debug("Executing SQL query [{}]", (Object)query);
            Collection results = ticketMapInstance.values(Predicates.sql((String)query));
            return results.stream().map(row -> this.decodeTicket(row.getTicket())).filter(ticket -> !ticket.isExpired());
        }
        return super.getSessionsWithAttributes(queryAttributes);
    }

    public Stream<? extends Ticket> getSessionsFor(String principalId) {
        if (this.properties.getCore().isEnableJet()) {
            TicketDefinition md = this.ticketCatalog.find("TGT");
            String sql = String.format("SELECT * FROM %s WHERE principal=?", md.getProperties().getStorageName());
            LOGGER.debug("Executing SQL query [{}]", (Object)sql);
            try (SqlResult results = this.hazelcastInstance.getSql().execute(sql, new Object[]{this.digestIdentifier(principalId)});){
                Stream stream = StreamSupport.stream(results.spliterator(), false).map(row -> {
                    Ticket ticket = (Ticket)row.getObject("ticket");
                    return this.decodeTicket(ticket);
                }).filter(ticket -> !ticket.isExpired()).toList().stream();
                return stream;
            }
        }
        return super.getSessionsFor(principalId);
    }

    public void shutdown() {
        FunctionUtils.doAndHandle(__ -> {
            LOGGER.info("Shutting down Hazelcast instance [{}]", (Object)this.hazelcastInstance.getConfig().getInstanceName());
            this.hazelcastInstance.shutdown();
        });
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private IMap<String, HazelcastTicketDocument> getTicketMapInstanceByMetadata(TicketDefinition metadata) {
        String mapName = metadata.getProperties().getStorageName();
        LOGGER.debug("Locating map name [{}] for ticket definition [{}]", (Object)mapName, (Object)metadata);
        return this.getTicketMapInstance(mapName);
    }

    private IMap<String, HazelcastTicketDocument> getTicketMapInstance(@NonNull String mapName) {
        if (mapName == null) {
            throw new NullPointerException("mapName is marked non-null but is null");
        }
        return (IMap)FunctionUtils.doAndHandle(() -> {
            IMap inst = this.hazelcastInstance.getMap(mapName);
            LOGGER.debug("Located Hazelcast map instance [{}]", (Object)mapName);
            return inst;
        });
    }
}

