/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.config.CasCoreAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasCoreAutoConfiguration;
import org.apereo.cas.config.CasCoreLogoutAutoConfiguration;
import org.apereo.cas.config.CasCoreNotificationsAutoConfiguration;
import org.apereo.cas.config.CasCoreServicesAutoConfiguration;
import org.apereo.cas.config.CasCoreTicketsAutoConfiguration;
import org.apereo.cas.config.CasCoreUtilAutoConfiguration;
import org.apereo.cas.config.CasCoreWebAutoConfiguration;
import org.apereo.cas.config.CasHazelcastTicketRegistryAutoConfiguration;
import org.apereo.cas.config.CasPersonDirectoryAutoConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasHazelcastTicketRegistryAutoConfiguration.class, CasCoreTicketsAutoConfiguration.class, CasCoreUtilAutoConfiguration.class, CasPersonDirectoryAutoConfiguration.class, CasCoreLogoutAutoConfiguration.class, CasCoreServicesAutoConfiguration.class, CasCoreAuthenticationAutoConfiguration.class, CasCoreAutoConfiguration.class, CasCoreNotificationsAutoConfiguration.class, CasCoreWebAutoConfiguration.class}, properties={"cas.ticket.registry.hazelcast.cluster.core.instance-name=samplelocalhostinstance", "cas.ticket.registry.hazelcast.cluster.network.port=5702"})
@Tag(value="Hazelcast")
class DefaultHazelcastInstanceConfigurationTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHazelcastInstanceConfigurationTests.class);
    @Autowired
    @Qualifier(value="casTicketRegistryHazelcastInstance")
    private HazelcastInstance hzInstance;

    DefaultHazelcastInstanceConfigurationTests() {
    }

    @Test
    void correctHazelcastInstanceIsCreated() {
        Assertions.assertNotNull((Object)this.hzInstance);
        Config config = this.hzInstance.getConfig();
        Assertions.assertFalse((boolean)config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled());
        Assertions.assertEquals(List.of("localhost"), (Object)config.getNetworkConfig().getJoin().getTcpIpConfig().getMembers());
        Assertions.assertTrue((boolean)config.getNetworkConfig().isPortAutoIncrement());
        Assertions.assertTrue((boolean)config.getManagementCenterConfig().isScriptingEnabled());
        Assertions.assertEquals((int)5702, (int)config.getNetworkConfig().getPort());
        Map mapConfigs = config.getMapConfigs();
        mapConfigs.forEach((key, value) -> LOGGER.info("Hazelcast map key [{}]", key));
        Assertions.assertTrue((boolean)mapConfigs.containsKey("proxyTicketsCache"));
        Assertions.assertTrue((boolean)mapConfigs.containsKey("proxyGrantingTicketsCache"));
        Assertions.assertTrue((boolean)mapConfigs.containsKey("serviceTicketsCache"));
        Assertions.assertTrue((boolean)mapConfigs.containsKey("ticketGrantingTicketsCache"));
        Assertions.assertTrue((boolean)mapConfigs.containsKey("transientSessionTicketsCache"));
    }

    @AfterEach
    public void shutdownHz() {
        LOGGER.info("Shutting down hazelcast instance [{}]", (Object)this.hzInstance.getConfig().getInstanceName());
        this.hzInstance.shutdown();
        while (this.hzInstance.getLifecycleService().isRunning()) {
            LOGGER.info("Waiting for instances to shut down");
        }
    }
}

