/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import lombok.Generated;
import org.apereo.cas.config.HazelcastTicketRegistryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryTicketCatalogConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.ticket.DefaultTicketDefinition;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.registry.BaseTicketRegistryTests;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;

@Tag(value="Hazelcast")
class HazelcastTicketRegistryTests {
    HazelcastTicketRegistryTests() {
    }

    @Nested
    @Import(value={HazelcastTicketRegistryConfiguration.class, HazelcastTicketRegistryTicketCatalogConfiguration.class, BaseTicketRegistryTests.SharedTestConfiguration.class})
    @TestPropertySource(properties={"cas.ticket.registry.hazelcast.cluster.network.port-auto-increment=false", "cas.ticket.registry.hazelcast.cluster.network.port=5703", "cas.ticket.registry.hazelcast.cluster.core.instance-name=testlocalhostinstance"})
    class DefaultTests
    extends BaseTicketRegistryTests {
        @Autowired
        @Qualifier(value="ticketRegistry")
        private TicketRegistry newTicketRegistry;
        @Autowired
        private CasConfigurationProperties casProperties;

        DefaultTests(HazelcastTicketRegistryTests this$0) {
        }

        @RepeatedTest(value=1)
        void verifyBadExpPolicyValue() throws Throwable {
            MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
            HazelcastInstance instance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
            IMap myMap = (IMap)Mockito.mock(IMap.class);
            Mockito.when((Object)instance.getMap(Mockito.anyString())).thenReturn((Object)myMap);
            try (HazelcastTicketRegistry registry = new HazelcastTicketRegistry(CipherExecutor.noOp(), this.ticketSerializationManager, this.ticketCatalog, instance, this.casProperties.getTicket().getRegistry().getHazelcast());){
                ticket.setExpirationPolicy((ExpirationPolicy)new HardTimeoutExpirationPolicy(-1L));
                Assertions.assertDoesNotThrow(() -> registry.addTicket((Ticket)ticket));
                Assertions.assertDoesNotThrow(() -> ((HazelcastTicketRegistry)registry).shutdown());
            }
        }

        @RepeatedTest(value=1)
        void verifyBadTicketInCatalog() throws Throwable {
            MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
            HazelcastInstance instance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
            Mockito.when((Object)instance.getMap(Mockito.anyString())).thenThrow(new Throwable[]{new RuntimeException()});
            TicketCatalog catalog = (TicketCatalog)Mockito.mock(TicketCatalog.class);
            DefaultTicketDefinition defn = new DefaultTicketDefinition(ticket.getClass(), TicketGrantingTicket.class, ticket.getPrefix(), 0);
            defn.getProperties().setStorageName("Tickets");
            Mockito.when((Object)catalog.find((Ticket)Mockito.any(Ticket.class))).thenReturn((Object)defn);
            try (HazelcastTicketRegistry registry = new HazelcastTicketRegistry(CipherExecutor.noOp(), this.ticketSerializationManager, catalog, instance, this.casProperties.getTicket().getRegistry().getHazelcast());){
                Assertions.assertDoesNotThrow(() -> registry.addTicket((Ticket)ticket));
                Assertions.assertNull((Object)registry.getTicket(ticket.getId()));
            }
        }

        @Generated
        public TicketRegistry getNewTicketRegistry() {
            return this.newTicketRegistry;
        }

        @Generated
        public CasConfigurationProperties getCasProperties() {
            return this.casProperties;
        }
    }

    @Nested
    @Import(value={HazelcastTicketRegistryConfiguration.class, HazelcastTicketRegistryTicketCatalogConfiguration.class, BaseTicketRegistryTests.SharedTestConfiguration.class})
    @TestPropertySource(properties={"cas.ticket.registry.hazelcast.core.enable-jet=false", "cas.ticket.registry.hazelcast.page-size=0", "cas.ticket.registry.hazelcast.cluster.network.port-auto-increment=false", "cas.ticket.registry.hazelcast.cluster.network.port=5707", "cas.ticket.registry.hazelcast.cluster.core.instance-name=testjetlessinstance"})
    class JetlessTests
    extends BaseTicketRegistryTests {
        @Autowired
        @Qualifier(value="ticketRegistry")
        private TicketRegistry newTicketRegistry;

        JetlessTests(HazelcastTicketRegistryTests this$0) {
        }

        @Generated
        public TicketRegistry getNewTicketRegistry() {
            return this.newTicketRegistry;
        }
    }
}

