/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.sql.SqlResult;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketDefinitionProperties;
import org.apereo.cas.ticket.registry.HazelcastTicketHolder;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.TicketRegistry, module="hazelcast")
@AutoConfiguration
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketRegistry ticketRegistry(@Qualifier(value="casTicketRegistryHazelcastInstance") HazelcastInstance casTicketRegistryHazelcastInstance, @Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, CasConfigurationProperties casProperties) {
        HazelcastTicketRegistryProperties hz = casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(casTicketRegistryHazelcastInstance, ticketCatalog, hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"casTicketRegistryHazelcastInstance"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public HazelcastInstance casTicketRegistryHazelcastInstance(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, CasConfigurationProperties casProperties) {
        HazelcastTicketRegistryProperties hz = casProperties.getTicket().getRegistry().getHazelcast();
        LOGGER.debug("Creating Hazelcast instance for members [{}]", (Object)hz.getCluster().getNetwork().getMembers());
        HazelcastInstance hazelcastInstance = HazelcastInstanceFactory.getOrCreateHazelcastInstance((Config)HazelcastConfigurationFactory.build((BaseHazelcastProperties)hz));
        Collection ticketDefinitions = ticketCatalog.findAll();
        ticketDefinitions.stream().map(defn -> {
            LOGGER.debug("Creating Hazelcast map configuration for [{}]", (Object)defn.getProperties());
            TicketDefinitionProperties props = defn.getProperties();
            NamedConfig cfg = HazelcastConfigurationFactory.buildMapConfig((BaseHazelcastProperties)hz, (String)props.getStorageName(), (long)props.getStorageTimeout());
            if (cfg instanceof MapConfig) {
                MapConfig mapConfig = (MapConfig)cfg;
                mapConfig.addIndexConfig(new IndexConfig(IndexType.HASH, new String[]{"id"}));
                mapConfig.addIndexConfig(new IndexConfig(IndexType.HASH, new String[]{"type"}));
                mapConfig.addIndexConfig(new IndexConfig(IndexType.HASH, new String[]{"principal"}));
            }
            return cfg;
        }).forEach(map -> HazelcastConfigurationFactory.setConfigMap((NamedConfig)map, (Config)hazelcastInstance.getConfig()));
        if (hz.getCore().isEnableJet()) {
            ticketDefinitions.forEach(defn -> {
                String query = HazelcastTicketRegistryConfiguration.buildCreateMappingQuery(defn);
                LOGGER.trace("Creating mapping for [{}] via [{}]", (Object)defn.getPrefix(), (Object)query);
                try (SqlResult createResults = hazelcastInstance.getSql().execute(query, new Object[0]);){
                    LOGGER.info("Created Hazelcast SQL mapping for [{}]", (Object)defn.getPrefix());
                }
            });
        }
        return hazelcastInstance;
    }

    private static String buildCreateMappingQuery(TicketDefinition defn) {
        StringBuilder builder = new StringBuilder(String.format("CREATE MAPPING IF NOT EXISTS \"%s\" ", defn.getProperties().getStorageName()));
        builder.append("TYPE IMap ");
        builder.append("OPTIONS (");
        builder.append("'keyFormat' = 'java',");
        builder.append("'keyJavaClass' = 'java.lang.String',");
        builder.append("'valueFormat' = 'java',");
        builder.append(String.format("'valueJavaClass' = '%s'", HazelcastTicketHolder.class.getName()));
        builder.append(')');
        return builder.toString();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }
}

