/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import lombok.Generated;
import org.apereo.cas.config.HazelcastTicketRegistryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryTicketCatalogConfiguration;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.ticket.DefaultTicketDefinition;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.registry.BaseTicketRegistryTests;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;

@Import(value={HazelcastTicketRegistryConfiguration.class, HazelcastTicketRegistryTicketCatalogConfiguration.class, BaseTicketRegistryTests.SharedTestConfiguration.class})
@TestPropertySource(properties={"cas.ticket.registry.hazelcast.cluster.network.port-auto-increment=false", "cas.ticket.registry.hazelcast.cluster.network.port=5703", "cas.ticket.registry.hazelcast.cluster.core.instance-name=testlocalhostinstance"})
@Tag(value="Hazelcast")
public class HazelcastTicketRegistryTests
extends BaseTicketRegistryTests {
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry newTicketRegistry;

    @RepeatedTest(value=1)
    public void verifyBadExpPolicyValue() {
        HazelcastInstance instance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        TicketCatalog catalog = (TicketCatalog)Mockito.mock(TicketCatalog.class);
        try (HazelcastTicketRegistry registry = new HazelcastTicketRegistry(instance, catalog, 0L);){
            MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
            ticket.setExpirationPolicy((ExpirationPolicy)new HardTimeoutExpirationPolicy(-1L));
            Assertions.assertThrows(IllegalArgumentException.class, () -> registry.addTicket((Ticket)ticket));
            Assertions.assertDoesNotThrow(() -> ((HazelcastTicketRegistry)registry).shutdown());
        }
    }

    @RepeatedTest(value=1)
    public void verifyBadTicketInCatalog() {
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        HazelcastInstance instance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)instance.getMap(Mockito.anyString())).thenThrow(new Throwable[]{new RuntimeException()});
        TicketCatalog catalog = (TicketCatalog)Mockito.mock(TicketCatalog.class);
        DefaultTicketDefinition defn = new DefaultTicketDefinition(ticket.getClass(), TicketGrantingTicket.class, ticket.getPrefix(), 0);
        defn.getProperties().setStorageName("Tickets");
        Mockito.when((Object)catalog.find((Ticket)Mockito.any(Ticket.class))).thenReturn((Object)defn);
        try (HazelcastTicketRegistry registry = new HazelcastTicketRegistry(instance, catalog, 0L);){
            Assertions.assertDoesNotThrow(() -> registry.addTicket((Ticket)ticket));
            Assertions.assertNull((Object)registry.getTicket(ticket.getId()));
        }
    }

    @Generated
    public TicketRegistry getNewTicketRegistry() {
        return this.newTicketRegistry;
    }
}

