/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.configuration.support.CasFeatureModule;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="HazelcastTicketRegistryConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeature(feature=CasFeatureModule.FeatureCatalog.TicketRegistry, module="hazelcast")
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketRegistry ticketRegistry(@Qualifier(value="casTicketRegistryHazelcastInstance") HazelcastInstance casTicketRegistryHazelcastInstance, @Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, CasConfigurationProperties casProperties) {
        HazelcastTicketRegistryProperties hz = casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(casTicketRegistryHazelcastInstance, ticketCatalog, hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"casTicketRegistryHazelcastInstance"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public HazelcastInstance casTicketRegistryHazelcastInstance(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, CasConfigurationProperties casProperties) {
        HazelcastTicketRegistryProperties hz = casProperties.getTicket().getRegistry().getHazelcast();
        LOGGER.debug("Creating Hazelcast instance for members [{}]", (Object)hz.getCluster().getNetwork().getMembers());
        HazelcastInstance hazelcastInstance = HazelcastInstanceFactory.getOrCreateHazelcastInstance((Config)HazelcastConfigurationFactory.build((BaseHazelcastProperties)hz));
        ticketCatalog.findAll().stream().map(TicketDefinition::getProperties).peek(p -> LOGGER.debug("Created Hazelcast map configuration for [{}]", p)).map(p -> HazelcastConfigurationFactory.buildMapConfig((BaseHazelcastProperties)hz, (String)p.getStorageName(), (long)p.getStorageTimeout())).forEach(map -> HazelcastConfigurationFactory.setConfigMap((NamedConfig)map, (Config)hazelcastInstance.getConfig()));
        return hazelcastInstance;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }
}

