/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class HazelcastTicketRegistry
extends AbstractTicketRegistry
implements AutoCloseable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistry.class);
    private final HazelcastInstance hazelcastInstance;
    private final TicketCatalog ticketCatalog;
    private final long pageSize;

    public Ticket updateTicket(Ticket ticket) {
        this.addTicket(ticket);
        return ticket;
    }

    public void addTicket(Ticket ticket) {
        Long ttl = ticket.getExpirationPolicy().getTimeToLive();
        if (ttl < 0L) {
            throw new IllegalArgumentException("The expiration policy of ticket " + ticket.getId() + " is set to use a negative ttl");
        }
        LOGGER.debug("Adding ticket [{}] with ttl [{}s]", (Object)ticket.getId(), (Object)ttl);
        Ticket encTicket = this.encodeTicket(ticket);
        TicketDefinition metadata = this.ticketCatalog.find(ticket);
        IMap<String, Ticket> ticketMap = this.getTicketMapInstanceByMetadata(metadata);
        if (ticketMap != null) {
            ticketMap.set((Object)encTicket.getId(), (Object)encTicket, ttl.longValue(), TimeUnit.SECONDS);
            LOGGER.debug("Added ticket [{}] with ttl [{}s]", (Object)encTicket.getId(), (Object)ttl);
        } else {
            LOGGER.warn("Unable to locate ticket map for ticket metadata [{}]", (Object)metadata);
        }
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        String encTicketId = this.encodeTicketId(ticketId);
        if (StringUtils.isBlank((CharSequence)encTicketId)) {
            return null;
        }
        TicketDefinition metadata = this.ticketCatalog.find(ticketId);
        if (metadata != null) {
            IMap<String, Ticket> map = this.getTicketMapInstanceByMetadata(metadata);
            if (map != null) {
                Ticket ticket = (Ticket)map.get((Object)encTicketId);
                Ticket result = this.decodeTicket(ticket);
                if (predicate.test(result)) {
                    return result;
                }
                return null;
            }
            LOGGER.error("Unable to locate ticket map for ticket definition [{}]", (Object)metadata);
        }
        LOGGER.warn("No ticket definition could be found in the catalog to match [{}]", (Object)ticketId);
        return null;
    }

    public boolean deleteSingleTicket(String ticketIdToDelete) {
        String encTicketId = this.encodeTicketId(ticketIdToDelete);
        TicketDefinition metadata = this.ticketCatalog.find(ticketIdToDelete);
        IMap<String, Ticket> map = this.getTicketMapInstanceByMetadata(metadata);
        return map != null && map.remove((Object)encTicketId) != null;
    }

    public long deleteAll() {
        return this.ticketCatalog.findAll().stream().map(this::getTicketMapInstanceByMetadata).filter(Objects::nonNull).mapToInt(instance -> {
            int size = instance.size();
            instance.evictAll();
            instance.clear();
            return size;
        }).sum();
    }

    public Collection<? extends Ticket> getTickets() {
        return this.ticketCatalog.findAll().stream().map(metadata -> this.getTicketMapInstanceByMetadata((TicketDefinition)metadata).values()).flatMap(tickets -> {
            if (this.pageSize > 0L) {
                return tickets.stream().limit(this.pageSize).collect(Collectors.toList()).stream();
            }
            return new ArrayList(tickets).stream();
        }).map(arg_0 -> ((HazelcastTicketRegistry)this).decodeTicket(arg_0)).collect(Collectors.toSet());
    }

    public void shutdown() {
        try {
            LOGGER.info("Shutting down Hazelcast instance [{}]", (Object)this.hazelcastInstance.getConfig().getInstanceName());
            this.hazelcastInstance.shutdown();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private IMap<String, Ticket> getTicketMapInstanceByMetadata(TicketDefinition metadata) {
        String mapName = metadata.getProperties().getStorageName();
        LOGGER.debug("Locating map name [{}] for ticket definition [{}]", (Object)mapName, (Object)metadata);
        return this.getTicketMapInstance(mapName);
    }

    private IMap<String, Ticket> getTicketMapInstance(@NonNull String mapName) {
        if (mapName == null) {
            throw new NullPointerException("mapName is marked non-null but is null");
        }
        try {
            IMap inst = this.hazelcastInstance.getMap(mapName);
            LOGGER.debug("Located Hazelcast map instance [{}]", (Object)mapName);
            return inst;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Generated
    public HazelcastTicketRegistry(HazelcastInstance hazelcastInstance, TicketCatalog ticketCatalog, long pageSize) {
        this.hazelcastInstance = hazelcastInstance;
        this.ticketCatalog = ticketCatalog;
        this.pageSize = pageSize;
    }
}

