/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryTicketCatalogConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.util.SchedulingUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(classes={HazelcastTestConfiguration.class, HazelcastTicketRegistryConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, RefreshAutoConfiguration.class, CasCoreTicketCatalogConfiguration.class, HazelcastTicketRegistryTicketCatalogConfiguration.class, CasCoreUtilConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreHttpConfiguration.class, CasCoreConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreServicesConfiguration.class, CasCoreWebConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class})
@DirtiesContext
public class DefaultHazelcastInstanceConfigurationTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHazelcastInstanceConfigurationTests.class);
    @Autowired
    @Qualifier(value="casTicketRegistryHazelcastInstance")
    private HazelcastInstance hzInstance;

    @Test
    public void correctHazelcastInstanceIsCreated() {
        Assertions.assertNotNull((Object)this.hzInstance);
        Config config = this.hzInstance.getConfig();
        Assertions.assertFalse((boolean)config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled());
        Assertions.assertEquals(List.of("localhost"), (Object)config.getNetworkConfig().getJoin().getTcpIpConfig().getMembers());
        Assertions.assertTrue((boolean)config.getNetworkConfig().isPortAutoIncrement());
        Assertions.assertEquals((int)5701, (int)config.getNetworkConfig().getPort());
        Assertions.assertEquals((int)5, (int)config.getMapConfigs().size());
    }

    @AfterEach
    public void shutdownHz() {
        LOGGER.info("Shutting down hazelcast instance [{}]", (Object)this.hzInstance.getConfig().getInstanceName());
        this.hzInstance.shutdown();
        while (this.hzInstance.getLifecycleService().isRunning()) {
            LOGGER.info("Waiting for instances to shut down");
        }
    }

    @TestConfiguration
    public static class HazelcastTestConfiguration
    implements InitializingBean {
        @Autowired
        protected ApplicationContext applicationContext;

        public void afterPropertiesSet() {
            SchedulingUtils.prepScheduledAnnotationBeanPostProcessor((ApplicationContext)this.applicationContext);
        }
    }
}

