/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.core.HazelcastInstance;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="hazelcastTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casHazelcastInstance")
    private ObjectProvider<HazelcastInstance> hazelcastInstance;
    @Autowired
    @Qualifier(value="ticketCatalog")
    private ObjectProvider<TicketCatalog> ticketCatalog;

    @Bean
    public TicketRegistry ticketRegistry() {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        ((TicketCatalog)this.ticketCatalog.getIfAvailable()).findAll().stream().map(TicketDefinition::getProperties).peek(p -> LOGGER.debug("Created Hazelcast map configuration for [{}]", p)).map(p -> factory.buildMapConfig((BaseHazelcastProperties)hz, p.getStorageName(), p.getStorageTimeout())).forEach(m -> ((HazelcastInstance)this.hazelcastInstance.getIfAvailable()).getConfig().addMapConfig(m));
        HazelcastTicketRegistry r = new HazelcastTicketRegistry((HazelcastInstance)this.hazelcastInstance.getIfAvailable(), (TicketCatalog)this.ticketCatalog.getIfAvailable(), hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }
}

