/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="hazelcastTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casHazelcastInstance")
    private HazelcastInstance hazelcastInstance;

    @Autowired
    @Bean
    public TicketRegistry ticketRegistry(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        this.buildHazelcastMapConfigurations(ticketCatalog).values().forEach(map -> this.hazelcastInstance.getConfig().addMapConfig(map));
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(this.hazelcastInstance, ticketCatalog, hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }

    private Map<String, MapConfig> buildHazelcastMapConfigurations(TicketCatalog ticketCatalog) {
        HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        Collection definitions = ticketCatalog.findAll();
        definitions.forEach(t -> {
            MapConfig mapConfig = factory.buildMapConfig((BaseHazelcastProperties)hz, t.getProperties().getStorageName(), t.getProperties().getStorageTimeout());
            LOGGER.debug("Created Hazelcast map configuration for [{}]", t);
            mapConfigs.put(t.getProperties().getStorageName(), mapConfig);
        });
        return mapConfigs;
    }
}

