/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="hazelcastTicketRegistryTicketMetadataCatalogConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryTicketCatalogConfiguration
extends CasCoreTicketCatalogConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryTicketCatalogConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    protected void buildAndRegisterServiceTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("serviceTicketsCache");
        metadata.getProperties().setStorageTimeout(this.casProperties.getTicket().getSt().getTimeToKillInSeconds());
        super.buildAndRegisterServiceTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterProxyTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("proxyTicketsCache");
        metadata.getProperties().setStorageTimeout((long)this.casProperties.getTicket().getPt().getTimeToKillInSeconds());
        super.buildAndRegisterProxyTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterTicketGrantingTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("ticketGrantingTicketsCache");
        metadata.getProperties().setStorageTimeout((long)this.casProperties.getTicket().getTgt().getMaxTimeToLiveInSeconds());
        super.buildAndRegisterTicketGrantingTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterProxyGrantingTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("proxyGrantingTicketsCache");
        metadata.getProperties().setStorageTimeout((long)this.casProperties.getTicket().getTgt().getMaxTimeToLiveInSeconds());
        super.buildAndRegisterProxyGrantingTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterTransientSessionTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("transientSessionTicketsCache");
        metadata.getProperties().setStorageTimeout(this.casProperties.getTicket().getTst().getTimeToKillInSeconds());
        super.buildAndRegisterTransientSessionTicketDefinition(plan, metadata);
    }
}

