/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.CoreTicketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="hazelcastTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Autowired
    @Bean
    public TicketRegistry ticketRegistry(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(this.hazelcast(ticketCatalog), ticketCatalog, hz.getPageSize());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)hz.getCrypto(), (String)"hazelcast"));
        return r;
    }

    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner() {
        return NoOpTicketRegistryCleaner.getInstance();
    }

    @Autowired
    @Bean
    public HazelcastInstance hazelcast(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        return Hazelcast.newHazelcastInstance((Config)this.getConfig(ticketCatalog));
    }

    private Config getConfig(TicketCatalog ticketCatalog) {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        Map<String, MapConfig> configs = this.buildHazelcastMapConfigurations(ticketCatalog);
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        return factory.build((BaseHazelcastProperties)hz, configs);
    }

    private Map<String, MapConfig> buildHazelcastMapConfigurations(TicketCatalog ticketCatalog) {
        HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        Collection definitions = ticketCatalog.findAll();
        definitions.forEach(t -> {
            MapConfig mapConfig = factory.buildMapConfig((BaseHazelcastProperties)hz, t.getProperties().getStorageName(), t.getProperties().getStorageTimeout());
            LOGGER.debug("Created Hazelcast map configuration for [{}]", t);
            mapConfigs.put(t.getProperties().getStorageName(), mapConfig);
        });
        return mapConfigs;
    }
}

