/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.CryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="hazelcastTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastTicketRegistryConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Autowired
    @Bean
    public TicketRegistry ticketRegistry(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        HazelcastProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(this.hazelcast(ticketCatalog), ticketCatalog, hz.getPageSize());
        r.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((CryptographyProperties)hz.getCrypto()));
        return r;
    }

    @Autowired
    @Bean
    public TicketRegistryCleaner ticketRegistryCleaner(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        return new NoOpTicketRegistryCleaner();
    }

    @Autowired
    @Bean
    public HazelcastInstance hazelcast(@Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog) {
        return Hazelcast.newHazelcastInstance((Config)this.getConfig(ticketCatalog));
    }

    private Config getConfig(TicketCatalog ticketCatalog) {
        Config config;
        HazelcastProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastProperties.Cluster cluster = hz.getCluster();
        if (hz.getConfigLocation() != null && hz.getConfigLocation().exists()) {
            try {
                URL configUrl = hz.getConfigLocation().getURL();
                LOGGER.debug("Loading Hazelcast configuration from [{}]", (Object)configUrl);
                config = new XmlConfigBuilder(hz.getConfigLocation().getInputStream()).build();
                config.setConfigurationUrl(configUrl);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            config = new Config();
            config.setProperty("hazelcast.prefer.ipv4.stack", String.valueOf(cluster.isIpv4Enabled()));
            TcpIpConfig tcpIpConfig = new TcpIpConfig().setEnabled(cluster.isTcpipEnabled()).setMembers(cluster.getMembers()).setConnectionTimeoutSeconds(cluster.getTimeout());
            LOGGER.debug("Created Hazelcast TCP/IP configuration [{}]", (Object)tcpIpConfig);
            MulticastConfig multicastConfig = new MulticastConfig().setEnabled(cluster.isMulticastEnabled());
            if (cluster.isMulticastEnabled()) {
                multicastConfig.setMulticastGroup(cluster.getMulticastGroup());
                multicastConfig.setMulticastPort(cluster.getMulticastPort());
                Set trustedInterfaces = StringUtils.commaDelimitedListToSet((String)cluster.getMulticastTrustedInterfaces());
                if (!trustedInterfaces.isEmpty()) {
                    multicastConfig.setTrustedInterfaces(trustedInterfaces);
                }
                multicastConfig.setMulticastTimeoutSeconds(cluster.getMulticastTimeout());
                multicastConfig.setMulticastTimeToLive(cluster.getMulticastTimeToLive());
            }
            LOGGER.debug("Created Hazelcast Multicast configuration [{}]", (Object)multicastConfig);
            JoinConfig joinConfig = new JoinConfig().setMulticastConfig(multicastConfig).setTcpIpConfig(tcpIpConfig);
            LOGGER.debug("Created Hazelcast join configuration [{}]", (Object)joinConfig);
            NetworkConfig networkConfig = new NetworkConfig().setPort(cluster.getPort()).setPortAutoIncrement(cluster.isPortAutoIncrement()).setJoin(joinConfig);
            LOGGER.debug("Created Hazelcast network configuration [{}]", (Object)networkConfig);
            config.setMapConfigs(this.buildHazelcastMapConfigurations(ticketCatalog)).setNetworkConfig(networkConfig);
        }
        return config.setInstanceName(cluster.getInstanceName()).setProperty("hazelcast.logging.type", cluster.getLoggingType()).setProperty("hazelcast.max.no.heartbeat.seconds", String.valueOf(cluster.getMaxNoHeartbeatSeconds()));
    }

    private Map<String, MapConfig> buildHazelcastMapConfigurations(TicketCatalog ticketCatalog) {
        HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
        Collection definitions = ticketCatalog.findAll();
        definitions.forEach(t -> {
            MapConfig mapConfig = this.createMapConfig((TicketDefinition)t);
            LOGGER.debug("Created Hazelcast map configuration for [{}]", t);
            mapConfigs.put(t.getProperties().getStorageName(), mapConfig);
        });
        return mapConfigs;
    }

    private MapConfig createMapConfig(TicketDefinition definition) {
        HazelcastProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastProperties.Cluster cluster = hz.getCluster();
        EvictionPolicy evictionPolicy = EvictionPolicy.valueOf((String)cluster.getEvictionPolicy());
        LOGGER.debug("Creating Hazelcast map configuration for [{}] with idle timeout [{}] second(s)", (Object)definition.getProperties().getStorageName(), (Object)definition.getProperties().getStorageTimeout());
        return new MapConfig().setName(definition.getProperties().getStorageName()).setMaxIdleSeconds((int)definition.getProperties().getStorageTimeout()).setBackupCount(cluster.getBackupCount()).setAsyncBackupCount(cluster.getAsyncBackupCount()).setEvictionPolicy(evictionPolicy).setMaxSizeConfig(new MaxSizeConfig().setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf((String)cluster.getMaxSizePolicy())).setSize(cluster.getMaxHeapSizePercentage()));
    }
}

