/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastTicketRegistry
extends AbstractTicketRegistry
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistry.class);
    private final HazelcastInstance hazelcastInstance;
    private final TicketCatalog ticketCatalog;
    private final int pageSize;

    public HazelcastTicketRegistry(HazelcastInstance hz, TicketCatalog plan, int pageSize) {
        this.hazelcastInstance = hz;
        this.pageSize = pageSize;
        this.ticketCatalog = plan;
        LOGGER.info("Setting up Hazelcast Ticket Registry instance [{}]", (Object)this.hazelcastInstance);
    }

    public Ticket updateTicket(Ticket ticket) {
        this.addTicket(ticket);
        return ticket;
    }

    public void addTicket(Ticket ticket) {
        long ttl = ticket.getExpirationPolicy().getTimeToLive();
        if (ttl < 0L) {
            throw new IllegalArgumentException("The expiration policy of ticket " + ticket.getId() + "is set to use a negative ttl");
        }
        LOGGER.debug("Adding ticket [{}] with ttl [{}s]", (Object)ticket.getId(), (Object)ttl);
        Ticket encTicket = this.encodeTicket(ticket);
        TicketDefinition metadata = this.ticketCatalog.find(ticket);
        IMap<String, Ticket> ticketMap = this.getTicketMapInstanceByMetadata(metadata);
        ticketMap.set((Object)encTicket.getId(), (Object)encTicket, ttl, TimeUnit.SECONDS);
        LOGGER.debug("Added ticket [{}] with ttl [{}s]", (Object)encTicket.getId(), (Object)ttl);
    }

    private IMap<String, Ticket> getTicketMapInstanceByMetadata(TicketDefinition metadata) {
        String mapName = metadata.getProperties().getStorageName();
        LOGGER.debug("Locating map name [{}] for ticket definition [{}]", (Object)mapName, (Object)metadata);
        return this.getTicketMapInstance(mapName);
    }

    public Ticket getTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        if (StringUtils.isNotBlank((CharSequence)encTicketId)) {
            TicketDefinition metadata = this.ticketCatalog.find(ticketId);
            if (metadata != null) {
                Ticket ticket = (Ticket)this.getTicketMapInstanceByMetadata(metadata).get((Object)encTicketId);
                return this.decodeTicket(ticket);
            }
            LOGGER.warn("No ticket definition could be found in the catalog to match [{}]", (Object)ticketId);
        }
        return null;
    }

    public boolean deleteSingleTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        TicketDefinition metadata = this.ticketCatalog.find(ticketId);
        IMap<String, Ticket> map = this.getTicketMapInstanceByMetadata(metadata);
        return map.remove((Object)encTicketId) != null;
    }

    public long deleteAll() {
        Collection metadata = this.ticketCatalog.findAll();
        AtomicLong count = new AtomicLong();
        metadata.forEach(r -> {
            IMap<String, Ticket> instance = this.getTicketMapInstanceByMetadata((TicketDefinition)r);
            if (instance != null) {
                count.addAndGet(instance.size());
                instance.evictAll();
                instance.clear();
            }
        });
        return count.get();
    }

    public Collection<Ticket> getTickets() {
        HashSet tickets = new HashSet();
        try {
            Collection metadata = this.ticketCatalog.findAll();
            metadata.forEach(t -> {
                IMap<String, Ticket> map = this.getTicketMapInstanceByMetadata((TicketDefinition)t);
                tickets.addAll(map.values().stream().limit(this.pageSize).collect(Collectors.toList()));
            });
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return this.decodeTickets(tickets);
    }

    @PreDestroy
    public void shutdown() {
        try {
            LOGGER.info("Shutting down Hazelcast instance [{}]", (Object)this.hazelcastInstance.getConfig().getInstanceName());
            this.hazelcastInstance.shutdown();
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    private IMap<String, Ticket> getTicketMapInstance(String mapName) {
        try {
            IMap inst = this.hazelcastInstance.getMap(mapName);
            LOGGER.debug("Located Hazelcast map instance [{}]", (Object)mapName);
            return inst;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

